/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.modes;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.utils.CustomColour;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.GSIInteractionHelper;
import sonar.logistics.core.tiles.displays.gsi.modes.GSICreateInfo;
import sonar.logistics.core.tiles.displays.gsi.modes.IGSIMode;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GSIGridMode
implements IGSIMode {
    public DisplayGSI gsi;
    public double[] clickPosition1;
    public double[] clickPosition2;
    public GSICreateInfo createInfo;
    public int containerResizing;

    public GSIGridMode(DisplayGSI gsi) {
        this.gsi = gsi;
    }

    @Override
    public boolean onClicked(TileAbstractDisplay part, BlockPos pos, DisplayScreenClick click, BlockInteractionType type, EntityPlayer player) {
        if (type.isShifting()) {
            if (type.isLeft() || this.clickPosition1 == null) {
                this.exitGridSelectionMode();
            } else {
                this.finishGridSelectionMode();
            }
        } else {
            double[] newPosition = new double[]{click.clickX, click.clickY};
            if (this.clickPosition1 == null) {
                this.clickPosition1 = newPosition;
            } else if (this.clickPosition2 == null) {
                this.clickPosition2 = newPosition;
            } else if (type.isLeft()) {
                this.clickPosition1 = newPosition;
            } else {
                this.clickPosition2 = newPosition;
            }
        }
        return true;
    }

    @Override
    public void renderMode() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.01);
        for (DisplayElementContainer container : this.gsi.containers.values()) {
            if (this.gsi.isEditContainer(container) || this.containerResizing == container.getContainerIdentity()) continue;
            double[] translation = container.getTranslation();
            double[] scaling = container.getContainerMaxScaling();
            DisplayElementHelper.drawRect(translation[0], translation[1], translation[0] + scaling[0], translation[1] + scaling[1], new CustomColour(255, 153, 51).getRGB());
        }
        if (this.clickPosition1 != null) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
            double[] click2 = this.clickPosition2 == null ? this.clickPosition1 : this.clickPosition2;
            double clickStartX = GSIInteractionHelper.getGridXPosition(this.gsi, Math.min(this.clickPosition1[0], click2[0]));
            double clickStartY = GSIInteractionHelper.getGridYPosition(this.gsi, Math.min(this.clickPosition1[1], click2[1]));
            double clickEndX = Math.min(this.gsi.getDisplayScaling()[0], GSIInteractionHelper.getGridXPosition(this.gsi, Math.max(this.clickPosition1[0], click2[0])) + GSIInteractionHelper.getGridXScale(this.gsi));
            double clickEndY = Math.min(this.gsi.getDisplayScaling()[1], GSIInteractionHelper.getGridYPosition(this.gsi, Math.max(this.clickPosition1[1], click2[1])) + GSIInteractionHelper.getGridYScale(this.gsi));
            DisplayElementHelper.drawRect(clickStartX, clickStartY, clickEndX, clickEndY, new CustomColour(49, 145, 88).getRGB());
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.001);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.001);
        CustomColour green = new CustomColour(174, 227, 227);
        DisplayElementHelper.drawGrid(0.0, 0.0, this.gsi.getDisplayScaling()[0], this.gsi.getDisplayScaling()[1], GSIInteractionHelper.getGridXScale(this.gsi), GSIInteractionHelper.getGridYScale(this.gsi), green.getRGB());
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean renderElements() {
        return false;
    }

    @Override
    public boolean renderEditContainer() {
        return false;
    }

    public void startResizeSelectionMode(int containerID) {
        DisplayElementContainer c = this.gsi.getContainer(containerID);
        if (c != null) {
            this.createInfo = null;
            this.gsi.mode = this.gsi.grid_mode;
            this.containerResizing = c.getContainerIdentity();
            this.clickPosition1 = c.getTranslation();
            this.clickPosition2 = new double[]{c.getTranslation()[0] + c.getContainerMaxScaling()[0] - 0.0625, c.getTranslation()[1] + c.getContainerMaxScaling()[1] - 0.0625, 0.0};
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("" + TextFormatting.GREEN + "L-CLICK" + TextFormatting.RESET + " = FIRST POSITION, " + TextFormatting.GREEN + "R-CLICK" + TextFormatting.RESET + " = SECOND POSITION, " + TextFormatting.GREEN + "SHIFT-R" + TextFormatting.RESET + " = CONFIRM, " + TextFormatting.RED + "SHIFT-L" + TextFormatting.RESET + " = CANCEL", new Object[0]));
        }
    }

    public void startGridSelectionMode(GSICreateInfo type) {
        this.createInfo = type;
        this.gsi.mode = this.gsi.grid_mode;
        this.clickPosition1 = null;
        this.clickPosition2 = null;
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("" + TextFormatting.GREEN + "L-CLICK" + TextFormatting.RESET + " = FIRST POSITION, " + TextFormatting.GREEN + "R-CLICK" + TextFormatting.RESET + " = SECOND POSITION, " + TextFormatting.GREEN + "SHIFT-R" + TextFormatting.RESET + " = CONFIRM, " + TextFormatting.RED + "SHIFT-L" + TextFormatting.RESET + " = CANCEL", new Object[0]));
    }

    public void exitGridSelectionMode() {
        this.gsi.mode = this.gsi.default_mode;
        this.clickPosition1 = null;
        this.clickPosition2 = null;
    }

    public void finishGridSelectionMode() {
        double[] click2 = this.clickPosition2 == null ? this.clickPosition1 : this.clickPosition2;
        double clickStartX = GSIInteractionHelper.getGridXPosition(this.gsi, Math.min(this.clickPosition1[0], click2[0]));
        double clickStartY = GSIInteractionHelper.getGridYPosition(this.gsi, Math.min(this.clickPosition1[1], click2[1]));
        double clickEndX = Math.min(this.gsi.getDisplayScaling()[0], GSIInteractionHelper.getGridXPosition(this.gsi, Math.max(this.clickPosition1[0], click2[0])) + GSIInteractionHelper.getGridXScale(this.gsi));
        double clickEndY = Math.min(this.gsi.getDisplayScaling()[1], GSIInteractionHelper.getGridYPosition(this.gsi, Math.max(this.clickPosition1[1], click2[1])) + GSIInteractionHelper.getGridYScale(this.gsi));
        if (this.createInfo != null) {
            GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createInfoAdditionPacket(new double[]{clickStartX, clickStartY, 0.0}, new double[]{clickEndX - clickStartX, clickEndY - clickStartY, 1.0}, 0.5, this.createInfo), -1, this.gsi);
        } else {
            GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createResizeContainerPacket(this.containerResizing, new double[]{clickStartX, clickStartY, 0.0}, new double[]{clickEndX - clickStartX, clickEndY - clickStartY, 1.0}, 0.5), -1, this.gsi);
            this.containerResizing = -1;
        }
        this.exitGridSelectionMode();
    }
}

