/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.ChunkHelper;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.ListHelper;
import sonar.logistics.PL2;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;
import sonar.logistics.network.packets.PacketConnectedDisplayUpdate;

public class DisplayViewerHandler {
    public static int CHECK_RADIUS = 8;
    public Map<Integer, List<ChunkPos>> displayChunks = new HashMap<Integer, List<ChunkPos>>();
    public Map<Integer, List<EntityPlayerMP>> cachedPlayers = new HashMap<Integer, List<EntityPlayerMP>>();
    public Map<EntityPlayerMP, Map<Integer, List<ChunkPos>>> UNWATCHED_CHUNKS = new HashMap<EntityPlayerMP, Map<Integer, List<ChunkPos>>>();
    public Map<EntityPlayerMP, Map<Integer, List<ChunkPos>>> WATCHED_CHUNKS = new HashMap<EntityPlayerMP, Map<Integer, List<ChunkPos>>>();
    public List<DisplayGSI> ADDED_DISPLAYS = new ArrayList<DisplayGSI>();
    public List<DisplayGSI> REMOVED_DISPLAYS = new ArrayList<DisplayGSI>();

    public static DisplayViewerHandler instance() {
        return PL2.proxy.chunkViewer;
    }

    public void removeAll() {
        this.displayChunks.clear();
        this.cachedPlayers.clear();
        this.UNWATCHED_CHUNKS.clear();
        this.WATCHED_CHUNKS.clear();
        this.ADDED_DISPLAYS.clear();
        this.REMOVED_DISPLAYS.clear();
    }

    public void onDisplayAdded(DisplayGSI display) {
        this.ADDED_DISPLAYS.add(display);
    }

    public void onDisplayRemoved(DisplayGSI display) {
        this.REMOVED_DISPLAYS.add(display);
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        EntityPlayerMP player = event.getPlayer();
        int dimensionID = event.getChunkInstance().func_177412_p().field_73011_w.getDimension();
        this.WATCHED_CHUNKS.computeIfAbsent(player, FunctionHelper.HASH_MAP);
        this.WATCHED_CHUNKS.get(player).computeIfAbsent(dimensionID, FunctionHelper.ARRAY);
        this.WATCHED_CHUNKS.get(player).get(dimensionID).add(event.getChunk());
    }

    @SubscribeEvent
    public void onChunkUnwatched(ChunkWatchEvent.UnWatch event) {
        EntityPlayerMP player = event.getPlayer();
        int dimensionID = event.getChunkInstance().func_177412_p().field_73011_w.getDimension();
        this.UNWATCHED_CHUNKS.computeIfAbsent(player, FunctionHelper.HASH_MAP);
        this.UNWATCHED_CHUNKS.get(player).computeIfAbsent(dimensionID, FunctionHelper.ARRAY);
        this.UNWATCHED_CHUNKS.get(player).get(dimensionID).add(event.getChunk());
    }

    public void onViewerAdded(DisplayGSI gsi, EntityPlayerMP player) {
        if (gsi.isValid()) {
            if (gsi.getDisplay() instanceof ConnectedDisplay) {
                ConnectedDisplay display = (ConnectedDisplay)gsi.getDisplay();
                PL2.network.sendTo((IMessage)new PacketConnectedDisplayUpdate(display, display.getRegistryID()), player);
            }
            gsi.sendValidatePacket(player);
            gsi.sendConnectedInfo((EntityPlayer)player);
            PL2.logger.info("Viewer Added: " + gsi.getDisplayGSIIdentity() + " " + player);
        }
    }

    public void onViewerRemoved(DisplayGSI gsi, EntityPlayerMP player) {
        gsi.sendInvalidatePacket(player);
    }

    public void updateDisplayViewers() {
        List<EntityPlayerMP> players;
        ArrayList displays;
        List<EntityPlayerMP> watchers;
        if (!this.ADDED_DISPLAYS.isEmpty()) {
            for (DisplayGSI displayGSI : this.ADDED_DISPLAYS) {
                if (!displayGSI.isValid()) continue;
                this.displayChunks.remove(displayGSI.getDisplayGSIIdentity());
                this.cachedPlayers.remove(displayGSI.getDisplayGSIIdentity());
                watchers = this.getWatchingPlayers(displayGSI);
                watchers.forEach(watcher -> this.onViewerAdded(gsi, (EntityPlayerMP)watcher));
            }
            this.ADDED_DISPLAYS.clear();
        }
        if (!this.REMOVED_DISPLAYS.isEmpty()) {
            for (DisplayGSI displayGSI : this.REMOVED_DISPLAYS) {
                watchers = this.getWatchingPlayers(displayGSI);
                watchers.forEach(watcher -> this.onViewerRemoved(gsi, (EntityPlayerMP)watcher));
                this.displayChunks.remove(displayGSI.getDisplayGSIIdentity());
                this.cachedPlayers.remove(displayGSI.getDisplayGSIIdentity());
            }
            this.REMOVED_DISPLAYS.clear();
        }
        if (!this.WATCHED_CHUNKS.isEmpty()) {
            for (Map.Entry entry : this.WATCHED_CHUNKS.entrySet()) {
                displays = new ArrayList();
                for (Map.Entry chunks : ((Map)entry.getValue()).entrySet()) {
                    for (ChunkPos pos : (List)chunks.getValue()) {
                        ListHelper.addWithCheck(displays, this.getDisplaysInChunk((Integer)chunks.getKey(), pos));
                    }
                }
                for (DisplayGSI gsi : displays) {
                    players = this.getWatchingPlayers(gsi);
                    if (players.contains(entry.getKey())) continue;
                    players.add((EntityPlayerMP)entry.getKey());
                    this.onViewerAdded(gsi, (EntityPlayerMP)entry.getKey());
                }
            }
            this.WATCHED_CHUNKS.clear();
        }
        if (!this.UNWATCHED_CHUNKS.isEmpty()) {
            for (Map.Entry entry : this.UNWATCHED_CHUNKS.entrySet()) {
                displays = new ArrayList();
                for (Map.Entry chunks : ((Map)entry.getValue()).entrySet()) {
                    for (ChunkPos pos : (List)chunks.getValue()) {
                        ListHelper.addWithCheck(displays, this.getDisplaysInChunk((Integer)chunks.getKey(), pos));
                    }
                }
                for (DisplayGSI gsi : displays) {
                    players = this.getWatchingPlayers(gsi);
                    if (players == null || !players.contains(entry.getKey())) continue;
                    players.remove(entry.getKey());
                    this.onViewerRemoved(gsi, (EntityPlayerMP)entry.getKey());
                }
            }
            this.UNWATCHED_CHUNKS.clear();
        }
    }

    public boolean hasViewers(World world, BlockPos pos) {
        return !ChunkHelper.getChunkPlayers((World)world, (BlockPos)pos).isEmpty();
    }

    public List<DisplayGSI> getDisplaysInChunk(int dim, ChunkPos pos) {
        ArrayList<DisplayGSI> inChunk = new ArrayList<DisplayGSI>();
        for (Map.Entry<Integer, List<ChunkPos>> chunks : this.displayChunks.entrySet()) {
            DisplayGSI gsi;
            if (!chunks.getValue().contains(pos) || (gsi = ServerInfoHandler.instance().getGSIMap().get(chunks.getKey())) == null || gsi.getWorld().field_73011_w.getDimension() != dim) continue;
            inChunk.add(gsi);
        }
        return inChunk;
    }

    public List<EntityPlayerMP> getWatchingPlayers(List<DisplayGSI> displays) {
        ArrayList<EntityPlayerMP> watchingPlayers = new ArrayList<EntityPlayerMP>();
        for (DisplayGSI display : displays) {
            List<EntityPlayerMP> players = this.getWatchingPlayers(display);
            if (players.isEmpty()) continue;
            ListHelper.addWithCheck(watchingPlayers, players);
        }
        return watchingPlayers;
    }

    public List<EntityPlayerMP> getWatchingPlayers(DisplayGSI d) {
        return this.cachedPlayers.computeIfAbsent(d.getDisplayGSIIdentity(), iden -> {
            World server = SonarCore.proxy.getDimension(d.getDisplay().getCoords().getDimension());
            return ChunkHelper.getChunkPlayers((World)server, this.getWatchingChunks(d));
        });
    }

    public Map<Integer, List<ChunkPos>> getWatchingChunks(List<DisplayGSI> displays) {
        HashMap<Integer, List<ChunkPos>> watchingChunks = new HashMap<Integer, List<ChunkPos>>();
        displays.forEach(display -> {
            int dim = display.getDisplay().getCoords().getDimension();
            List<ChunkPos> displayChunks = this.getWatchingChunks((DisplayGSI)((Object)display));
            watchingChunks.putIfAbsent(dim, new ArrayList());
            List chunks = (List)watchingChunks.get(dim);
            displayChunks.forEach(chunk -> {
                if (!chunks.contains(chunk)) {
                    chunks.add(chunk);
                }
            });
        });
        return watchingChunks;
    }

    public List<ChunkPos> getWatchingChunks(DisplayGSI gsi) {
        List<ChunkPos> positions = this.displayChunks.get(gsi.getDisplayGSIIdentity());
        if (positions == null) {
            BlockPos pos = gsi.getDisplay().getCoords().getBlockPos();
            this.displayChunks.put(gsi.getDisplayGSIIdentity(), ChunkHelper.getChunksInRadius((BlockPos)pos, (double)CHECK_RADIUS));
            positions = this.displayChunks.get(gsi.getDisplayGSIIdentity());
        }
        return positions;
    }
}

