/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.ICableConnectable;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ISmallDisplay;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.base.utils.worlddata.GSIData;
import sonar.logistics.core.tiles.connections.data.handling.AbstractConnectionHandler;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.displays.DisplayViewerHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplayChange;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;
import sonar.logistics.network.packets.PacketConnectedDisplayUpdate;

public class DisplayHandler
extends AbstractConnectionHandler<ILargeDisplay> {
    public final Map<Integer, List<ConnectedDisplayChange>> display_updates = new HashMap<Integer, List<ConnectedDisplayChange>>();
    public final Map<Integer, TileAbstractHolographicDisplay> holographic_displays = new HashMap<Integer, TileAbstractHolographicDisplay>();
    public List<Integer> rebuild = Lists.newArrayList();

    public static DisplayHandler instance() {
        return PL2.proxy.server_display_manager;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.rebuild.clear();
        this.display_updates.clear();
        this.holographic_displays.clear();
    }

    public void updateConnectedDisplays() {
        if (!this.display_updates.isEmpty()) {
            Map<Integer, ConnectedDisplay> connected = ServerInfoHandler.instance().getConnectedDisplays();
            if (!connected.isEmpty()) {
                connected.values().forEach(this::runChanges);
            }
            this.display_updates.clear();
        }
    }

    public void onDisplayAddition(ILargeDisplay display) {
        ListHelper.addWithCheck(this.rebuild, (Object)display.getRegistryID());
        this.addConnectionToNetwork(display);
        ListHelper.addWithCheck(this.rebuild, (Object)display.getRegistryID());
    }

    public void onDisplayRemoval(ILargeDisplay display) {
        ListHelper.addWithCheck(this.rebuild, (Object)display.getRegistryID());
        this.removeConnectionFromNetwork(display);
        ListHelper.addWithCheck(this.rebuild, (Object)display.getRegistryID());
    }

    public void addDisplay(IDisplay display, PL2AdditionType type) {
        DisplayGSI gsi;
        if (display instanceof ISmallDisplay) {
            ISmallDisplay screen = (ISmallDisplay)display;
            screen.setGSI(new DisplayGSI(display, display.getActualWorld(), display.getInfoContainerID()));
            NBTTagCompound tag = GSIData.unloadedGSI.get(display.getInfoContainerID());
            if (tag != null) {
                screen.getGSI().readData(tag, NBTHelper.SyncType.SAVE);
            }
        }
        if ((gsi = display.getGSI()) != null && gsi.getDisplay() != null && !ServerInfoHandler.instance().gsiMap.containsValue((Object)gsi)) {
            this.validateGSI(display, gsi);
        }
    }

    public void removeDisplay(IDisplay display, PL2RemovalType type) {
        DisplayGSI gsi;
        if (display instanceof ISmallDisplay) {
            ISmallDisplay screen = (ISmallDisplay)display;
            if (type == PL2RemovalType.PLAYER_REMOVED) {
                GSIData.unloadedGSI.remove(display.getInfoContainerID());
            } else if (display.getGSI() != null) {
                GSIData.unloadedGSI.put(display.getInfoContainerID(), display.getGSI().writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
            }
        }
        if ((gsi = display.getGSI()) != null && gsi.getDisplay() != null) {
            this.invalidateGSI(display, gsi);
        }
    }

    public static void addClientDisplay(IDisplay display, PL2AdditionType type) {
        if (!ClientInfoHandler.instance().displays_tile.containsKey(display.getIdentity())) {
            NBTTagCompound tag;
            ClientInfoHandler.instance().displays_tile.put(display.getIdentity(), display);
            if (display instanceof ILargeDisplay && (display = (IDisplay)((ILargeDisplay)display).getConnectedDisplay().orElse(null)) == null) {
                return;
            }
            DisplayGSI gsi = display.getGSI();
            if (gsi == null) {
                gsi = new DisplayGSI(display, display.getActualWorld(), display.getInfoContainerID());
                display.setGSI(gsi);
            }
            if ((tag = ClientInfoHandler.instance().invalid_gsi.get(display.getInfoContainerID())) != null) {
                gsi.readData(tag, NBTHelper.SyncType.SAVE);
                gsi.validate();
                ClientInfoHandler.instance().invalid_gsi.remove(display.getInfoContainerID());
            }
        }
    }

    public static void removeClientDisplay(IDisplay display, PL2RemovalType type) {
        IDisplay current = ClientInfoHandler.instance().displays_tile.get(display.getIdentity());
        if (current == display) {
            ClientInfoHandler.instance().displays_tile.remove(display.getIdentity());
        }
    }

    public void validateGSI(IDisplay display, DisplayGSI gsi) {
        if (display == gsi.getDisplay().getActualDisplay()) {
            gsi.validate();
            gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
            DisplayViewerHandler.instance().onDisplayAdded(gsi);
        }
    }

    public void invalidateGSI(IDisplay display, DisplayGSI gsi) {
        gsi.invalidate();
        DisplayViewerHandler.instance().onDisplayRemoved(gsi);
    }

    public void createConnectedDisplays() {
        for (Integer i : this.rebuild) {
            ConnectedDisplay display = ServerInfoHandler.instance().getConnectedDisplays().get(i);
            List displays = this.getConnections(i);
            if (displays.isEmpty()) {
                if (display != null) {
                    this.invalidateGSI(display, display.getGSI());
                }
                ServerInfoHandler.instance().getConnectedDisplays().remove(i);
                continue;
            }
            if (display == null) {
                ILargeDisplay first_display = (ILargeDisplay)displays.get(0);
                World world = first_display.getActualWorld();
                ConnectedDisplay connectedDisplay = ConnectedDisplay.loadDisplay(world, i);
                ServerInfoHandler.instance().getConnectedDisplays().put(i, connectedDisplay);
                connectedDisplay.face.setObject((Enum)first_display.getCableFace());
                connectedDisplay.setDisplayScaling();
                connectedDisplay.getGSI().validate();
                this.markConnectedDisplayChanged(i, ConnectedDisplayChange.SUB_NETWORK_CHANGED, ConnectedDisplayChange.SUB_DISPLAY_CHANGED, ConnectedDisplayChange.WATCHERS_CHANGED);
                continue;
            }
            this.markConnectedDisplayChanged(i, ConnectedDisplayChange.SUB_DISPLAY_CHANGED, ConnectedDisplayChange.WATCHERS_CHANGED);
        }
    }

    public void markConnectedDisplayChanged(int registryID, ConnectedDisplayChange ... changes) {
        this.display_updates.putIfAbsent(registryID, new ArrayList());
        for (ConnectedDisplayChange change : changes) {
            if (this.display_updates.get(registryID).contains((Object)change)) continue;
            this.display_updates.get(registryID).add(change);
        }
    }

    public List<ConnectedDisplayChange> getChanges(int registryID) {
        return this.display_updates.getOrDefault(registryID, new ArrayList());
    }

    public void runChanges(ConnectedDisplay display) {
        List<ConnectedDisplayChange> changes = this.getChanges(display.getRegistryID());
        for (ConnectedDisplayChange change : ConnectedDisplayChange.values()) {
            if (!change.shouldRunChange(changes) || change.doChange(changes, display)) continue;
            changes.remove((Object)change);
            return;
        }
    }

    public static boolean updateLargeDisplays(List<ConnectedDisplayChange> changes, ConnectedDisplay display) {
        List displays = DisplayHandler.instance().getConnections(display.getRegistryID());
        if (!displays.isEmpty()) {
            display.setDisplayScaling();
            DisplayHandler.instance().markConnectedDisplayChanged(display.getRegistryID(), ConnectedDisplayChange.WATCHERS_CHANGED, ConnectedDisplayChange.SUB_NETWORK_CHANGED);
            return true;
        }
        return false;
    }

    public static boolean updateConnectedNetworks(List<ConnectedDisplayChange> changes, ConnectedDisplay display) {
        display.getGSI().validateAllInfoReferences();
        return true;
    }

    public static boolean updateWatchers(List<ConnectedDisplayChange> changes, ConnectedDisplay display) {
        if (display.getCoords() != null) {
            List<EntityPlayerMP> watchers = DisplayViewerHandler.instance().getWatchingPlayers(display.getGSI());
            watchers.forEach(watcher -> PL2.network.sendTo((IMessage)new PacketConnectedDisplayUpdate(display, display.getRegistryID()), watcher));
        }
        return true;
    }

    @Override
    public int getNextAvailableID() {
        return ServerInfoHandler.instance().getNextIdentity();
    }

    @Override
    public Pair<EnumCableConnectionType, Integer> getConnectionType(ILargeDisplay source, World world, BlockPos pos, EnumFacing dir, EnumCableConnectionType cableType) {
        ICableConnectable connection = CableConnectionHelper.getConnection(source, dir, EnumCableConnection.NETWORK, false);
        if (connection instanceof ILargeDisplay && ((ILargeDisplay)connection).getCableFace() == source.getCableFace()) {
            return new Pair((Object)EnumCableConnectionType.SCREEN, (Object)((ILargeDisplay)connection).getRegistryID());
        }
        return new Pair((Object)EnumCableConnectionType.NONE, (Object)-1);
    }

    @Override
    public void onNetworksConnected(int newID, int oldID) {
        ConnectedDisplay screen = ServerInfoHandler.instance().getConnectedDisplays().get(newID);
        ServerInfoHandler.instance().getConnectedDisplays().remove(oldID);
        this.markConnectedDisplayChanged(oldID, ConnectedDisplayChange.SUB_DISPLAY_CHANGED);
        if (screen != null) {
            this.markConnectedDisplayChanged(newID, ConnectedDisplayChange.SUB_DISPLAY_CHANGED);
        } else {
            PL2.logger.error("CONNECTED DISPLAY SCREEN SHOULD NOT BE NULL!");
        }
    }

    @Override
    public void onConnectionAdded(int registryID, ILargeDisplay added) {
        this.markConnectedDisplayChanged(registryID, ConnectedDisplayChange.SUB_DISPLAY_CHANGED);
    }

    @Override
    public void onConnectionRemoved(int registryID, ILargeDisplay added) {
        this.markConnectedDisplayChanged(registryID, ConnectedDisplayChange.SUB_DISPLAY_CHANGED);
    }

    @Override
    public void onNetworksDisconnected(List<Integer> newNetworks) {
    }

    public Pair<EnumCableConnectionType, Integer> getConnectionTypeFromObject(ILargeDisplay source, Object connection, EnumFacing dir, EnumCableConnectionType cableType) {
        return new Pair((Object)EnumCableConnectionType.NONE, (Object)-1);
    }

    @Override
    public void addConnectionToNetwork(ILargeDisplay add) {
        this.addConnection(add);
    }

    @Override
    public void removeConnectionFromNetwork(ILargeDisplay remove) {
        this.removeConnection(remove);
    }
}

