/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RayTraceHelper;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.PL2Properties;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.data.IDataCable;
import sonar.logistics.core.tiles.base.BlockLogistics;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHandler;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.data.tiles.TileDataCable;

public class BlockDataCable
extends BlockLogistics {
    public BlockDataCable() {
        super(PL2Multiparts.DATA_CABLE);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PL2Properties.cableBox;
    }

    public static List<AxisAlignedBB> getSelectionBoxes(World world, BlockPos pos, List<AxisAlignedBB> collidingBoxes) {
        collidingBoxes.add((AxisAlignedBB)PL2Properties.cableBox);
        TileDataCable cable = CableConnectionHelper.getCable((IBlockAccess)world, pos);
        if (cable != null) {
            for (EnumFacing face : EnumFacing.values()) {
                EnumCableRenderSize connect = cable.getRenderType(face);
                if (!connect.canConnect()) continue;
                collidingBoxes.add(PL2Properties.getCableBox(connect, face));
            }
        }
        return collidingBoxes;
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState);
        List<AxisAlignedBB> boxes = BlockDataCable.getSelectionBoxes(world, pos, new ArrayList<AxisAlignedBB>());
        boxes.forEach(box -> BlockDataCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)box));
    }

    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return (RayTraceResult)RayTraceHelper.rayTraceBoxes((BlockPos)pos, (Vec3d)start, (Vec3d)end, BlockDataCable.getSelectionBoxes(world, pos, new ArrayList<AxisAlignedBB>())).getLeft();
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileDataCable cable = CableConnectionHelper.getCable((IBlockAccess)world, pos);
        if (cable != null && !world.field_72995_K) {
            CableConnectionHandler.instance().queueCableUpdate(cable);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileDataCable cable = CableConnectionHelper.getCable(world, pos);
        if (cable != null && !cable.func_145831_w().field_72995_K) {
            CableConnectionHandler.instance().queueCableUpdate(cable);
        }
    }

    public void onPartChanged(IPartInfo part, IPartInfo otherPart) {
        if (!part.getActualWorld().field_72995_K && part.getTile() != null && part.getTile() instanceof IDataCable) {
            CableConnectionHandler.instance().queueCableUpdate((IDataCable)part.getTile());
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileDataCable) {
            FontHelper.sendMessage((String)("ID: " + ((TileDataCable)tile).registryID.getObject()), (World)world, (EntityPlayer)player);
        }
        return false;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileDataCable cable = CableConnectionHelper.getCable(world, pos);
        if (cable == null) {
            return state;
        }
        for (PL2Properties.PropertyCableFace p : PL2Properties.CABLE_FACES) {
            state = state.func_177226_a((IProperty)p, (Comparable)((Object)CableConnectionHelper.getConnectionRenderType(cable, p.face)));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        for (PL2Properties.PropertyCableFace p : PL2Properties.CABLE_FACES) {
            state = state.func_177226_a((IProperty)p, (Comparable)((Object)EnumCableRenderSize.NONE));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])PL2Properties.CABLE_FACES);
    }

    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumCenterSlot.CENTER;
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return EnumCenterSlot.CENTER;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDataCable();
    }
}

