/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.wirelessstoragereader;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.UniversalChangeableList;
import sonar.logistics.api.core.tiles.readers.IWirelessStorageReader;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.gui.GuiSelectionGrid;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.core.items.wirelessstoragereader.ContainerStorageViewer;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.SortingHelper;
import sonar.logistics.core.tiles.readers.fluids.FluidReader;
import sonar.logistics.core.tiles.readers.items.InventoryReader;
import sonar.logistics.core.tiles.wireless.emitters.TileDataEmitter;
import sonar.logistics.network.packets.PacketWirelessStorage;

public class GuiWirelessStorageReader
extends GuiSelectionGrid<IInfo> {
    public static final ResourceLocation sorting_icons = new ResourceLocation("practicallogistics2:textures/gui/sorting_icons.png");
    private SonarTextField searchField;
    public EntityPlayer player;
    public int identity;
    public int networkID;
    public ItemStack reader;
    public static boolean items = true;
    public static SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public static SyncEnum<InventoryReader.SortingType> sortItems = (SyncEnum)new SyncEnum((Enum[])InventoryReader.SortingType.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public static SyncEnum<FluidReader.SortingType> sortfluids = (SyncEnum)new SyncEnum((Enum[])FluidReader.SortingType.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});

    public GuiWirelessStorageReader(ItemStack reader, int identity, int networkID, EntityPlayer player) {
        super(new ContainerStorageViewer(identity, player), null);
        this.reader = reader;
        this.identity = identity;
        this.networkID = networkID;
        this.player = player;
    }

    @Override
    public void func_73866_w_() {
        this.eWidth = items ? 18 : 27;
        this.eHeight = items ? 18 : 27;
        this.gWidth = items ? 12 : 8;
        this.gHeight = items ? 7 : 5;
        super.func_73866_w_();
        this.initButtons();
        this.searchField = new SonarTextField(1, this.field_146289_q, 135, 10, 104, 14);
        this.searchField.func_146203_f(20);
        this.fieldList.add(this.searchField);
    }

    public void initButtons() {
        super.initButtons();
        int start = 8;
        this.field_146292_n.add(new LogisticsButton.CHANNELS((GuiSonar)this, 2, this.field_147003_i + start, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton.HELP((GuiSonar)this, 5, this.field_147003_i + start + 36, this.field_147009_r + 9));
        if (items) {
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + this.field_146999_f - 168 + 18, this.field_147009_r + 9, 32, 16 * ((SortingDirection)sortingOrder.getObject()).ordinal(), PL2Translate.BUTTON_SORTING_ORDER.t(), ""));
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + this.field_146999_f - 168 + 36, this.field_147009_r + 9, 112, 16 * ((InventoryReader.SortingType)sortItems.getObject()).ordinal(), ((InventoryReader.SortingType)sortItems.getObject()).getClientName(), ""));
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 3, this.field_147003_i + 203, this.field_147009_r + 174, 32, 0, PL2Translate.BUTTON_DUMP_PLAYER.t(), ""));
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 4, this.field_147003_i + 203 + 18, this.field_147009_r + 174, 32, 16, PL2Translate.BUTTON_DUMP_NETWORK.t(), ""));
        } else {
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + this.field_146999_f - 168 + 18, this.field_147009_r + 9, 32, 16 * ((SortingDirection)sortingOrder.getObject()).ordinal(), PL2Translate.BUTTON_SORTING_ORDER.t(), ""));
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + this.field_146999_f - 168 + 36, this.field_147009_r + 9, 112, 16 * ((FluidReader.SortingType)sortfluids.getObject()).ordinal(), ((FluidReader.SortingType)sortfluids.getObject()).getClientName(), ""));
        }
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 6, this.field_147003_i + start + 18, this.field_147009_r + 9, 16, items ? 80 : 96, "Storage Type: " + (items ? "Items" : "Fluids"), "button.StorageType"));
    }

    public void func_146284_a(GuiButton button) {
        if (button != null) {
            switch (button.field_146127_k) {
                case 0: {
                    sortingOrder.incrementEnum();
                    this.initButtons();
                    break;
                }
                case 1: {
                    if (items) {
                        sortItems.incrementEnum();
                    } else {
                        sortfluids.incrementEnum();
                    }
                    this.initButtons();
                    break;
                }
                case 2: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)((IFlexibleGui)this.player.func_184614_ca().func_77973_b()), (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 3: {
                    PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                        public void writeToBuf(ByteBuf buf) {
                            buf.writeBoolean(false);
                            buf.writeInt(3);
                        }
                    }));
                    break;
                }
                case 4: {
                    PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                        public void writeToBuf(ByteBuf buf) {
                            buf.writeBoolean(false);
                            buf.writeInt(4);
                        }
                    }));
                    break;
                }
                case 5: {
                    GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                    this.reset();
                    break;
                }
                case 6: {
                    items = !items;
                    this.reset();
                }
            }
        }
    }

    public void switchState() {
        SonarCore.refreshFlexibleContainer((EntityPlayer)this.player);
    }

    @Override
    public void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        if (k == 1) {
            this.searchField.func_146180_a("");
        }
    }

    @Override
    public List<IInfo> getGridList() {
        String search = this.searchField.func_146179_b();
        if (items) {
            AbstractChangeableList currentList = ClientInfoHandler.instance().getChangeableListMap().get(new InfoUUID(this.identity, TileDataEmitter.STATIC_ITEM_ID));
            if (currentList == null) {
                return new ArrayList<IInfo>();
            }
            SortingHelper.sortItems(currentList, (SortingDirection)sortingOrder.getObject(), (InventoryReader.SortingType)sortItems.getObject());
            if (search.isEmpty() || search.equals(" ")) {
                return Lists.newArrayList(currentList.createSaveableList());
            }
            ArrayList<IInfo> searchlist = new ArrayList<IInfo>();
            List cached = currentList.createSaveableList();
            for (MonitoredItemStack stack : cached) {
                StoredItemStack item = stack.getStoredStack();
                if (item == null || !item.item.func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
                searchlist.add(stack);
            }
            return searchlist;
        }
        InfoUUID fluidUUID = new InfoUUID(this.identity, TileDataEmitter.STATIC_FLUID_ID);
        return ((AbstractChangeableList)ClientInfoHandler.instance().getChangeableListMap().getOrDefault(fluidUUID, UniversalChangeableList.newChangeableList())).createSaveableList();
    }

    @Override
    public void onGridClicked(final IInfo info, int x, int y, int pos, int button, boolean empty) {
        if (Keyboard.isKeyDown((int)42)) {
            button = 2;
        }
        final int usedButton = button;
        if (!empty && info instanceof MonitoredItemStack) {
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    MonitoredItemStack selection = (MonitoredItemStack)info;
                    if (selection.getStoredStack().item != null) {
                        buf.writeBoolean(true);
                        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)selection.getStoredStack().item);
                    } else {
                        buf.writeBoolean(false);
                    }
                    buf.writeInt(usedButton);
                }
            }));
        } else if (empty) {
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    buf.writeBoolean(false);
                    buf.writeInt(usedButton);
                }
            }));
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void renderGridElement(IInfo info, int x, int y, int slot) {
        if (info instanceof MonitoredItemStack) {
            MonitoredItemStack selection = (MonitoredItemStack)info;
            StoredItemStack storedStack = selection.getStoredStack();
            if (storedStack == null) {
                return;
            }
            ItemStack stack = storedStack.item;
            stack.func_190920_e(1);
            this.drawNormalItemStack(stack, 0, 0);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)stack, (long)storedStack.stored, (int)0, (int)0, null, (boolean)true);
        } else if (info instanceof InfoNetworkFluid) {
            InfoNetworkFluid selection = (InfoNetworkFluid)info;
            StoredFluidStack fluidStack = selection.getStoredStack();
            if (fluidStack.fluid != null) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluidStack.fluid.getFluid().getStill().toString());
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(0, 0, sprite, this.eWidth - 2, this.eHeight - 2);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void renderElementToolTip(IInfo info, int x, int y) {
        if (info instanceof MonitoredItemStack) {
            MonitoredItemStack selection = (MonitoredItemStack)info;
            StoredItemStack storedStack = selection.getStoredStack();
            if (storedStack == null) {
                return;
            }
            List list = storedStack.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            list.add(1, PL2Translate.BUTTON_STORED.t() + ": " + storedStack.stored);
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, storedStack.item.func_77953_t().field_77937_e + (String)list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY + (String)list.get(k));
            }
            FontRenderer font = storedStack.item.func_77973_b().getFontRenderer(storedStack.item);
            this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        } else if (info instanceof InfoNetworkFluid) {
            InfoNetworkFluid element = (InfoNetworkFluid)info;
            StoredFluidStack fluidStack = element.getStoredStack();
            ArrayList<String> list = new ArrayList<String>();
            list.add(fluidStack.fluid.getFluid().getLocalizedName(fluidStack.fluid));
            if (fluidStack.stored != 0L) {
                list.add(TextFormatting.GRAY + PL2Translate.BUTTON_STORED.t() + ": " + fluidStack.stored + " mB");
            }
            this.drawHoveringText(list, x, y, this.field_146289_q);
        }
    }
}

