/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.operator;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RayTraceHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.PL2;
import sonar.logistics.api.core.items.operator.IOperatorTile;
import sonar.logistics.api.core.items.operator.IOperatorTool;
import sonar.logistics.api.core.items.operator.OperatorMode;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.ContainerChannelSelection;
import sonar.logistics.base.channels.GuiChannelSelection;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.tiles.IChannelledTile;

public class ItemOperator
extends SonarItem
implements IOperatorTool,
IFlexibleGui<ItemStack> {
    @Override
    public OperatorMode getOperatorMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return OperatorMode.values()[stack.func_77978_p().func_74762_e("mode")];
        }
        return OperatorMode.DEFAULT;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Optional c = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos);
        if (c.isPresent()) {
            Object part;
            IBlockState state = world.func_180495_p(pos);
            RayTraceResult result = RayTraceHelper.getRayTraceEyes((EntityPlayer)player);
            IMultipartContainer container = (IMultipartContainer)c.get();
            if (result == null) {
                return EnumActionResult.PASS;
            }
            Optional multipartTile = SonarMultipartHelper.getMultipartTileFromSlotID((IBlockAccess)world, (BlockPos)pos, (int)result.subHit);
            Object object = part = multipartTile.isPresent() ? multipartTile.get() : world.func_175625_s(pos);
            if (part == null) {
                return EnumActionResult.PASS;
            }
            OperatorMode mode = this.getOperatorMode(player.func_184586_b(hand));
            switch (mode) {
                case ANALYSE: {
                    break;
                }
                case DEFAULT: {
                    if (player.func_70093_af() || !(part instanceof IOperatorTile)) break;
                    boolean operation = ((IOperatorTile)part).performOperation(result, mode, player, hand, facing, hitX, hitY, hitZ);
                    return operation ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                }
                case CHANNELS: {
                    if (part instanceof IChannelledTile) {
                        if (!world.field_72995_K) {
                            IChannelledTile tile = (IChannelledTile)part;
                            tile.getNetwork().sendConnectionsPacket(player);
                            NBTTagCompound tag = new NBTTagCompound();
                            tag.func_74757_a(FlexibleGuiHandler.ITEM, true);
                            tag.func_74768_a(FlexibleGuiHandler.ID, 0);
                            tag.func_74768_a("hash", tile.getIdentity());
                            SonarCore.instance.guiHandler.openGui(false, player, world, pos, 0, tag);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                    FontHelper.sendMessage((String)"This block has no channels", (World)world, (EntityPlayer)player);
                    break;
                }
                case INFO: {
                    break;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        OperatorMode mode;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            stack = this.changeOperatorMode(stack);
            FontHelper.sendMessage((String)("Mode: " + (Object)((Object)this.getOperatorMode(stack))), (World)world, (EntityPlayer)player);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.field_72995_K && (mode = this.getOperatorMode(stack)) == OperatorMode.INFO) {
            boolean isUsing = !PL2.proxy.isUsingOperator();
            PL2.proxy.setUsingOperator(isUsing);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("Display Info: " + TextFormatting.AQUA + isUsing, new Object[0]));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack changeOperatorMode(ItemStack stack) {
        OperatorMode mode = (OperatorMode)SonarHelper.incrementEnum((Enum)this.getOperatorMode(stack), (Enum[])OperatorMode.values());
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tag.func_74768_a("mode", mode.ordinal());
        stack.func_77982_d(tag);
        boolean isUsing = mode == OperatorMode.INFO;
        return stack;
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add("Mode: " + (Object)((Object)this.getOperatorMode(stack)));
    }

    public Object getServerElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                ILogicListenable listen = ServerInfoHandler.instance().getNetworkTileMap().get(tag.func_74762_e("hash"));
                if (!(listen instanceof IChannelledTile)) break;
                IChannelledTile tile = (IChannelledTile)listen;
                return new ContainerChannelSelection(tile);
            }
        }
        return null;
    }

    public Object getClientElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                ILogicListenable listen = ClientInfoHandler.instance().getNetworkTileMap().get(tag.func_74762_e("hash"));
                if (!(listen instanceof IChannelledTile)) break;
                IChannelledTile tile = (IChannelledTile)listen;
                return new GuiChannelSelection(player, tile, 0);
            }
        }
        return null;
    }

    public void onGuiOpened(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
    }
}

