/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.guide.pages.elements;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.logistics.core.items.guide.GuiGuide;
import sonar.logistics.core.items.guide.GuidePageRegistry;
import sonar.logistics.core.items.guide.pages.elements.IGuidePageElement;
import sonar.logistics.core.items.guide.pages.pages.IGuidePage;

public abstract class ElementRecipe<R>
implements IGuidePageElement {
    public int x;
    public int y;
    public int cycle;
    public EntityPlayer player;
    public List<List<ItemStack>> stacks = Lists.newArrayList((Object[])new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()});
    public List<Integer> positions;
    public int[][] slots = this.setSlots();
    public static int slotSize = 24;
    public int page;
    public ItemStack stack;
    public R recipe;

    public ElementRecipe(int page, EntityPlayer player, ItemStack stack, int x, int y) {
        this.page = page;
        this.stack = stack;
        this.x = x;
        this.y = y;
        this.player = player;
        this.recipe = this.getRecipe();
    }

    public abstract int[][] setSlots();

    public abstract R getRecipe();

    public abstract int recipeSize();

    @Override
    public int getDisplayPage() {
        return this.page;
    }

    public int getSlot(int x, int y, int mouseX, int mouseY) {
        int slotX = mouseX - x - slotSize;
        int slotY = mouseY - y - 8 - slotSize * 2;
        for (int pos = 0; pos < this.slots.length; ++pos) {
            int[] slot = this.slots[pos];
            if (slot[0] < slotX || slot[0] > slotX + slotSize || slot[1] < slotY || slot[1] > slotY + slotSize) continue;
            return pos;
        }
        return -1;
    }

    public ItemStack getStack(int pos) {
        List<ItemStack> list;
        if (pos != -1 && !(list = this.stacks.get(pos)).isEmpty()) {
            Integer cyclePos = this.positions.get(pos);
            return list.get(cyclePos);
        }
        return null;
    }

    public List<Integer> getPos() {
        ++this.cycle;
        if (this.positions == null || this.cycle == 40) {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            for (List<ItemStack> craft : this.stacks) {
                int i = craft.isEmpty() ? 0 : Math.abs(SonarCore.rand.nextInt()) % Math.max(craft.size(), 1);
                ints.add(i);
            }
            this.positions = ints;
            this.cycle = 0;
        }
        return this.positions;
    }

    @Override
    public void drawElement(GuiGuide gui, int x, int y, int page, int mouseX, int mouseY) {
        ItemStack stack = this.getStack(this.getSlot(x, y, mouseX, mouseY));
        if (stack != null) {
            gui.drawNormalToolTip(stack, gui.getGuiLeft() + mouseX, gui.getGuiTop() + mouseY);
        }
    }

    @Override
    public boolean mouseClicked(GuiGuide gui, IGuidePage page, int x, int y, int button) {
        IGuidePage stackPage;
        ItemStack stack = this.getStack(this.getSlot(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, x, y));
        if (stack != null && (stackPage = GuidePageRegistry.getGuidePage(stack)) != null) {
            gui.setCurrentPage(stackPage.pageID(), 0);
        }
        return false;
    }
}

