/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.guide.pages.elements;

import com.google.common.base.Objects;
import sonar.logistics.core.items.guide.GuiGuide;
import sonar.logistics.core.items.guide.GuidePageRegistry;
import sonar.logistics.core.items.guide.pages.pages.IGuidePage;

public class ElementLink {
    public int guidePageLink;
    public int lineNum;
    public int index;
    public int stringWidth;
    public int displayPage;
    public int displayX;
    public int displayY;
    private IGuidePage cached;

    public ElementLink(int guidePageLink, int stringWidth, int lineNum, int index) {
        this.guidePageLink = guidePageLink;
        this.stringWidth = stringWidth;
        this.lineNum = lineNum;
        this.index = index;
    }

    public ElementLink setDisplayPosition(int displayPage, int displayX, int displayY) {
        this.displayPage = displayPage;
        this.displayX = displayX;
        this.displayY = displayY;
        return this;
    }

    public IGuidePage getGuidePage() {
        if (this.cached != null) {
            return this.cached;
        }
        this.cached = GuidePageRegistry.getGuidePage(this.guidePageLink);
        return this.cached;
    }

    public boolean isMouseOver(GuiGuide gui, int x, int y) {
        return x >= this.displayX && x <= this.displayX + this.stringWidth && y >= this.displayY && y <= this.displayY + 10;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.guidePageLink, this.lineNum, this.index, this.stringWidth});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementLink) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }
}

