/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.requests.info;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.utils.CustomColour;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.overlays.OverlayBlockSelection;
import sonar.logistics.base.requests.info.IInfoRequirement;
import sonar.logistics.base.requests.info.InfoUUIDRequest;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;

public class GuiInfoSource
extends GuiSelectionList<Object> {
    public IInfoRequirement element;
    public List<InfoUUID> selected;
    public DisplayGSI gsi;

    public GuiInfoSource(IInfoRequirement element, DisplayGSI gsi, Container container) {
        super(container, gsi.getDisplay());
        this.element = element;
        this.gsi = gsi;
        this.selected = element.getSelectedInfo();
        this.field_146999_f = 248;
        this.field_147000_g = 166;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.scroller = new SonarScroller(this.field_147003_i + 164 + 71, this.field_147009_r + 29, 134, 10);
        for (int i = 0; i < this.size; ++i) {
            this.field_146292_n.add(new GuiSelectionList.SelectionButton(this, 10 + i, this.field_147003_i + 7, this.field_147009_r + 29 + i * 12, this.listWidth, this.listHeight));
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)(TextFormatting.BOLD + "Info Source"), (int)this.field_146999_f, (int)6, (CustomColour)PL2Colours.white_text);
        FontHelper.textCentre((String)"Select data to display", (int)this.field_146999_f, (int)18, (CustomColour)PL2Colours.white_text);
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(Object info) {
        if (info instanceof IInfoProvider && !OverlayBlockSelection.positions.isEmpty()) {
            return OverlayBlockSelection.isPositionRenderered(((IInfoProvider)info).getCoords());
        }
        return false;
    }

    @Override
    public boolean isSelectedInfo(Object info) {
        return info instanceof InfoUUID && this.selected.contains(info);
    }

    @Override
    public boolean isCategoryHeader(Object info) {
        return info instanceof ClientLocalProvider;
    }

    @Override
    public void renderInfo(Object info, int yPos) {
        if (info instanceof InfoUUID) {
            IInfo monitorInfo = ClientInfoHandler.instance().getInfoMap().get(info);
            if (monitorInfo != null) {
                InfoRenderHelper.renderMonitorInfoInGUI(monitorInfo, yPos + 1, PL2Colours.white_text.getRGB());
            } else {
                FontHelper.text((String)"-", (int)InfoRenderHelper.left_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
            }
        } else if (info instanceof ClientLocalProvider) {
            ClientLocalProvider monitor = (ClientLocalProvider)info;
            FontHelper.text((String)monitor.stack.func_82833_r(), (int)InfoRenderHelper.left_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
            FontHelper.text((String)monitor.coords.getCoords().toString(), (int)InfoRenderHelper.middle_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
        }
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, Object info) {
        if (buttonID == 0 && info instanceof InfoUUID) {
            InfoUUID uuid = (InfoUUID)info;
            if (this.selected.size() < this.element.getRequired()) {
                ListHelper.addWithCheck(this.selected, (Object)uuid);
            } else if (!this.selected.contains(uuid)) {
                this.selected.remove(0);
                this.selected.add(uuid);
            }
        } else if (info instanceof IInfoProvider) {
            OverlayBlockSelection.addPosition(((IInfoProvider)info).getCoords(), false);
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.isCloseKey(i) && this.selected.size() == this.element.getRequired()) {
            this.element.onGuiClosed(this.selected);
        }
        if (this.element instanceof InfoUUIDRequest) {
            FMLClientHandler.instance().showGuiScreen((Object)((InfoUUIDRequest)this.element).screen);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void setInfo() {
        this.infoList = Lists.newArrayList((Iterable)ClientInfoHandler.instance().sortedLogicMonitors.getOrDefault(this.gsi.getDisplayGSIIdentity(), new ArrayList()));
    }
}

