/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.guidance.errors;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.guidance.errors.ErrorAbstractUUID;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.tiles.INetworkTile;

public abstract class ErrorTileUUID
extends ErrorAbstractUUID
implements INBTSyncable,
IInfoError {
    public int identity;
    public ItemStack displayStack;
    public BlockCoords coords;

    public ErrorTileUUID() {
    }

    public ErrorTileUUID(InfoUUID uuid, INetworkTile tile) {
        this(Lists.newArrayList((Object[])new InfoUUID[]{uuid}), tile);
    }

    public ErrorTileUUID(List<InfoUUID> uuids, INetworkTile tile) {
        super(uuids);
        this.identity = tile.getIdentity();
        this.displayStack = tile.getDisplayStack();
        this.coords = tile.getCoords();
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.identity = nbt.func_74762_e("iden");
        this.displayStack = new ItemStack(nbt);
        this.coords = BlockCoords.readFromNBT((NBTTagCompound)nbt);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("iden", this.identity);
        this.displayStack.func_77955_b(nbt);
        BlockCoords.writeToNBT((NBTTagCompound)nbt, (BlockCoords)this.coords);
        return nbt;
    }
}

