/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiGridElement;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.utils.IWorldPosition;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.PL2Colours;

public abstract class GuiSelectionGrid<T extends IInfo>
extends GuiLogistics {
    public static final ResourceLocation sorting_icons = new ResourceLocation("practicallogistics2:textures/gui/sorting_icons.png");
    public int yPos = 32;
    public int xPos = 13;
    public int eWidth = 18;
    public int eHeight = 18;
    public int gWidth = 12;
    public int gHeight = 7;
    public SelectionGrid grid;

    public GuiSelectionGrid(Container container, IWorldPosition entity) {
        super(container, entity);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scroller = new SonarScroller(this.field_147003_i + this.xPos + this.eWidth * this.gWidth + 3, this.field_147009_r + this.yPos - 1, this.eHeight * this.gHeight + 2, 10);
        this.grid = new SelectionGrid(this, 0, this.xPos, this.yPos, this.eWidth, this.eHeight, this.gWidth, this.gHeight);
    }

    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || button == 1) {
            this.grid.mouseClicked((GuiSonar)this, x, y, button);
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.renderStrings(x, y);
        this.grid.renderGrid((GuiSonar)this, x, y);
    }

    public void startToolTipRender(T selection, int x, int y) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.renderElementToolTip(selection, x, y);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scroller.handleMouse((GuiGridElement)this.grid);
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.grid.setList(Lists.newArrayList(this.getGridList()));
        this.scroller.drawScreen(x, y, this.grid.isScrollable());
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        this.renderPlayerInventory(40, 173);
        GuiSelectionGrid.drawTransparentRect((int)(this.field_147003_i + this.xPos - 1), (int)(this.field_147009_r + this.yPos - 1), (int)(this.field_147003_i + this.xPos + this.eWidth * this.gWidth - 1), (int)(this.field_147009_r + this.yPos + this.eHeight * this.gHeight - 1), (int)PL2Colours.grey_base.getRGB());
        GuiSelectionGrid.drawTransparentRect((int)(this.field_147003_i + this.xPos), (int)(this.field_147009_r + this.yPos), (int)(this.field_147003_i + this.xPos + this.eWidth * this.gWidth - 2), (int)(this.field_147009_r + this.yPos + this.eHeight * this.gHeight - 2), (int)PL2Colours.blue_overlay.getRGB());
        GuiSelectionGrid.drawTransparentRect((int)(this.field_147003_i + 12), (int)(this.field_147009_r + 170), (int)(this.field_147003_i + this.field_146999_f - 9), (int)(this.field_147009_r + 252), (int)PL2Colours.grey_base.getRGB());
        GuiSelectionGrid.drawTransparentRect((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 171), (int)(this.field_147003_i + this.field_146999_f - 10), (int)(this.field_147009_r + 251), (int)PL2Colours.blue_overlay.getRGB());
    }

    public abstract void onGridClicked(T var1, int var2, int var3, int var4, int var5, boolean var6);

    public abstract void renderGridElement(T var1, int var2, int var3, int var4);

    public abstract void renderStrings(int var1, int var2);

    public abstract void renderElementToolTip(T var1, int var2, int var3);

    public abstract List<T> getGridList();

    public void preRender() {
    }

    public void postRender() {
    }

    public static class SelectionGrid<T extends IInfo>
    extends GuiGridElement<T> {
        public GuiSelectionGrid<T> selectGrid;

        public SelectionGrid(GuiSelectionGrid<T> selectGrid, int gridID, int yPos, int xPos, int eWidth, int eHeight, int gWidth, int gHeight) {
            super(gridID, yPos, xPos, eWidth, eHeight, gWidth, gHeight);
            this.selectGrid = selectGrid;
        }

        public float getCurrentScroll() {
            return this.selectGrid.scroller.getCurrentScroll();
        }

        public void onGridClicked(T selection, int x, int y, int pos, int button, boolean empty) {
            this.selectGrid.onGridClicked(selection, x, y, pos, button, empty);
        }

        public void renderGridElement(T selection, int x, int y, int slot) {
            this.selectGrid.renderGridElement(selection, x, y, slot);
        }

        public void renderElementToolTip(T selection, int x, int y) {
            this.selectGrid.startToolTipRender(selection, x, y);
        }

        public void preRender() {
            this.selectGrid.preRender();
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
        }

        public void postRender() {
            this.selectGrid.postRender();
        }
    }
}

