/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.events;

import mcmultipart.MCMultiPart;
import mcmultipart.RayTraceHelper;
import mcmultipart.block.BlockMultipartContainer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import sonar.core.api.utils.BlockInteractionType;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.displays.tiles.BlockClickableDisplay;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.nodes.array.TileArray;

public class PL2Events {
    public static final int saveDimension = 0;
    public static int coolDownClick = 0;
    public static long tickStart = 0L;
    public static long updateTick = 0L;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            tickStart = System.nanoTime();
            LogisticsEventHandler.instance().triggerConstructingPhase();
            LogisticsEventHandler.instance().triggerUpdatingPhase();
            LogisticsEventHandler.instance().triggerNotifyingPhase();
            TileArray.entityChanged = false;
            updateTick = System.nanoTime() - tickStart;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (coolDownClick != 0) {
            --coolDownClick;
        }
    }

    @SubscribeEvent
    public void clientDisconnection(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ClientInfoHandler.instance().removeAll();
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        TileArray.entityChanged = true;
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        if (world != null && player != null) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            IDisplay display = CableConnectionHelper.getDisplay(world, pos, EnumDisplayFaceSlot.fromFace(event.getFace()));
            if (display instanceof TileAbstractDisplay) {
                Pair pair;
                BlockMultipartContainer container;
                RayTraceResult result;
                TileAbstractDisplay tile = (TileAbstractDisplay)display;
                if (!(tile.func_145838_q() instanceof BlockClickableDisplay)) {
                    return;
                }
                if (block == MCMultiPart.multipart && ((result = (container = (BlockMultipartContainer)block).func_180636_a(state, world, pos, (Vec3d)(pair = RayTraceHelper.getRayTraceVectors((EntityPlayer)player)).getLeft(), (Vec3d)pair.getRight())) == null || result.subHit != tile.getSlotID())) {
                    return;
                }
                if (coolDownClick == 0 && display.getGSI() != null) {
                    Vec3d vec = event.getHitVec();
                    float vecX = (float)vec.field_72450_a - (float)pos.func_177958_n();
                    float vecY = (float)vec.field_72448_b - (float)pos.func_177956_o();
                    float vecZ = (float)vec.field_72449_c - (float)pos.func_177952_p();
                    coolDownClick = 3;
                    BlockInteractionType interactionType = player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT;
                    display.getGSI().onClicked((TileAbstractDisplay)display, interactionType, world, pos, state, player, event.getHand(), event.getFace(), vecX, vecY, vecZ);
                }
                event.setCanceled(true);
            }
        }
    }
}

