/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EventScheduler {
    public Map<Event, Integer> scheduled_events = new HashMap<Event, Integer>();
    public Map<Runnable, Integer> scheduled_runnables = new HashMap<Runnable, Integer>();

    public void scheduleEvent(Event event, int ticksToWait) {
        this.scheduled_events.put(event, ticksToWait);
    }

    public void scheduleRunnable(Runnable action, int ticksToWait) {
        this.scheduled_runnables.put(action, ticksToWait);
    }

    public void flushEvents() {
        Map.Entry<Object, Integer> entry;
        Iterator<Map.Entry<Object, Integer>> it;
        if (!this.scheduled_events.isEmpty()) {
            it = this.scheduled_events.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (entry.getValue() <= 0) {
                    MinecraftForge.EVENT_BUS.post((Event)entry.getKey());
                    it.remove();
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
            }
        }
        if (!this.scheduled_runnables.isEmpty()) {
            it = this.scheduled_runnables.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (entry.getValue() <= 0) {
                    ((Runnable)entry.getKey()).run();
                    it.remove();
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
            }
        }
    }
}

