/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data.holders;

import java.util.ArrayList;
import java.util.List;
import sonar.logistics.base.data.api.IDataCombinable;
import sonar.logistics.base.data.api.IDataFactory;
import sonar.logistics.base.data.api.IDataHolder;
import sonar.logistics.base.data.api.IDataWatcher;
import sonar.logistics.base.data.holders.DataHolder;
import sonar.logistics.base.data.sources.IDataMultiSource;

public class DataHolderMultiSource<D extends IDataCombinable>
extends DataHolder<D, DataHolderMultiSource<D>>
implements IDataWatcher {
    public final List<IDataHolder> subDataHolders = new ArrayList<IDataHolder>();
    public final List<IDataHolder<IDataCombinable>> changedHolders = new ArrayList<IDataHolder<IDataCombinable>>();
    public final IDataFactory<D> factory;

    public DataHolderMultiSource(IDataMultiSource source, IDataFactory<D> factory, int tickRate) {
        super(null, source, factory.create(), tickRate);
        this.factory = factory;
    }

    public void addDataHolder(IDataHolder<D> holder) {
        if (holder != null) {
            this.subDataHolders.add(holder);
        }
    }

    public void removeDataHolder(IDataHolder<D> holder) {
        if (holder != null) {
            this.subDataHolders.remove(holder);
        }
    }

    @Override
    public boolean isWatched() {
        return this.hasWatchers();
    }

    @Override
    public List<IDataHolder> getDataHolders() {
        return this.subDataHolders;
    }

    @Override
    public void onDataChanged(IDataHolder holder) {
        if (holder.getData() instanceof IDataCombinable) {
            this.changedHolders.add(holder);
        }
    }

    @Override
    public void onWatchersChanged() {
        super.onWatchersChanged();
        this.subDataHolders.forEach(h -> h.onWatchersChanged());
    }

    @Override
    public boolean canUpdateData() {
        return !this.changedHolders.isEmpty() && super.canUpdateData();
    }

    public void updateMultiSourceData() {
        boolean changed = false;
        for (IDataHolder<IDataCombinable> holder : this.changedHolders) {
            if (!((IDataCombinable)this.getData()).canCombine(holder.getData()) || !((IDataCombinable)this.getData()).doCombine(holder.getData())) continue;
            changed = true;
        }
        this.changedHolders.clear();
        if (changed) {
            this.onDataChanged();
        }
    }
}

