/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels.handling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkListChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkListHandler;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.handling.DefaultNetworkChannels;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.UpdateListenerList;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;

public abstract class ListNetworkChannels<M extends IInfo, H extends INetworkListHandler>
extends DefaultNetworkChannels
implements INetworkListChannels<H> {
    public final H handler;
    public List<IListReader<M>> readers = new ArrayList<IListReader<M>>();
    protected Iterator<IListReader<M>> readerIterator;
    public boolean shouldRapidUpdate;
    protected int readersPerTick = 0;
    public Map<Integer, List<NodeConnection>> usedChannels = new HashMap<Integer, List<NodeConnection>>();
    public Map<NodeConnection, AbstractChangeableList<M>> channels = new HashMap<NodeConnection, AbstractChangeableList<M>>();
    protected Iterator<Map.Entry<NodeConnection, AbstractChangeableList<M>>> channelIterator;
    protected int channelsPerTick = 0;
    protected UpdateListenerList UPDATES = new UpdateListenerList();

    protected ListNetworkChannels(H handler, ILogisticsNetwork network) {
        super(network, CacheHandler.READER);
        this.handler = handler;
    }

    public void updateListenerList() {
        this.UPDATES.reset();
        block0: for (IListReader<M> reader : this.readers) {
            if (!this.UPDATES.canAccept()) break;
            List listeners = reader.getListenerList().getTallies(ListenerType.values());
            for (ListenerTally t : listeners) {
                int[] tallies = t.tallies;
                for (int i = 0; i < tallies.length; ++i) {
                    int tally = tallies[i];
                    if (tally <= 0) continue;
                    this.UPDATES.add(ListenerType.values()[i]);
                }
                if (this.UPDATES.canAccept()) continue;
                break block0;
            }
            if (!reader.getListenerList().getDisplayListeners().hasListeners()) continue;
            this.UPDATES.add(ListenerType.OLD_DISPLAY_LISTENER);
        }
    }

    @Override
    public H getHandler() {
        return this.handler;
    }

    @Override
    public int getUpdateRate() {
        return this.handler.updateRate();
    }

    @Override
    public void updateChannel() {
        this.updateListenerList();
        super.updateChannel();
        this.runUpdates();
    }

    public void runUpdates() {
        if (this.UPDATES.canSyncUpdate(ListenerType.UpdateType.GUI, ListenerType.UpdateType.DISPLAY)) {
            this.updateChannels();
            this.updateReaders(true);
        }
    }

    public void runChannelUpdates() {
        this.updateTickLists();
    }

    @Override
    protected void tickChannels() {
        super.tickChannels();
        this.runChannelUpdates();
    }

    public void updateTickLists() {
        this.readersPerTick = this.readers.size() > this.handler.updateRate() ? (int)Math.ceil(this.readers.size() / Math.max(1, this.handler.updateRate())) : 1;
        this.channelsPerTick = this.channels.size() > this.handler.updateRate() ? (int)Math.ceil(this.channels.size() / Math.max(1, this.handler.updateRate())) : 1;
        this.channelIterator = this.channels.entrySet().iterator();
        this.readerIterator = this.readers.iterator();
    }

    @Override
    public void addConnection(INetworkTile connection) {
        IListReader reader = (IListReader)connection;
        if (reader.getValidHandlers().contains(this.handler) && !this.readers.contains(reader) && this.readers.add(reader)) {
            this.onChannelsChanged();
            this.tickChannels();
        }
    }

    @Override
    public void removeConnection(INetworkTile connection) {
        if (connection instanceof IListReader && this.readers.remove(connection)) {
            this.removeReaderUsedChannels(((IListReader)connection).getIdentity());
            this.onChannelsChanged();
            this.tickChannels();
        }
    }

    @Override
    public void onChannelsChanged() {
        this.channels = this.handler.getAllChannels(new HashMap(), this.network);
        this.readers.forEach(this::updateReaderUsedChannels);
        this.tickChannels();
    }

    public void updateReaderUsedChannels(IListReader reader) {
        this.usedChannels.put(reader.getIdentity(), reader.getUsedChannels(this.channels));
    }

    public void removeReaderUsedChannels(int identity) {
        this.usedChannels.remove(identity);
    }

    public void updateChannels() {
        for (int used = 0; this.channelIterator.hasNext() && used != this.channelsPerTick; ++used) {
            Map.Entry<NodeConnection, AbstractChangeableList<M>> entry = this.channelIterator.next();
            AbstractChangeableList<M> newList = this.handler.updateConnection(this, entry.getValue(), entry.getKey());
            this.channels.put(entry.getKey(), newList);
        }
    }

    public void updateReaders(boolean send) {
        for (int used = 0; this.readerIterator.hasNext() && used != this.readersPerTick; ++used) {
            IListReader<M> reader = this.readerIterator.next();
            if (!reader.getListenerList().hasListeners()) continue;
            this.handler.updateAndSendList(this.network, reader, this.channels, send);
        }
    }

    public void updateAllChannels() {
        for (Map.Entry<NodeConnection, AbstractChangeableList<M>> entry : this.channels.entrySet()) {
            this.channels.put(entry.getKey(), this.handler.updateConnection(this, entry.getValue(), entry.getKey()));
        }
    }

    public void updateAllReaders(boolean send) {
        this.readers.forEach(reader -> this.handler.updateAndSendList(this.network, reader, this.channels, send));
    }

    public void sendFullRapidUpdate() {
        this.updateAllChannels();
        this.updateAllReaders(true);
    }

    public void sendLocalRapidUpdate(IListReader<M> reader, EntityPlayer viewer) {
        PlayerListener listener = reader.getListenerList().findListener(viewer);
        if (listener != null) {
            this.updateAllChannels();
            Pair<InfoUUID, AbstractChangeableList<M>> list = this.handler.updateAndSendList(this.network, reader, this.channels, false);
            InfoPacketHelper.sendReaderFullInfo(Lists.newArrayList((Object[])new PlayerListener[]{listener}), reader, (AbstractChangeableList)list.b, (InfoUUID)list.a);
        }
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.readers.clear();
        this.readerIterator = null;
        this.channels.clear();
        this.channelIterator = null;
    }

    @Override
    public void onCreated() {
    }

    @Override
    public boolean isCoordsMonitored(BlockConnection connection) {
        return true;
    }

    @Override
    public boolean isEntityMonitored(EntityConnection connection) {
        return true;
    }
}

