/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.displays.tiles;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.listener.ISonarListener;
import sonar.core.network.sync.ISyncableListener;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;

public interface IDisplay
extends INetworkTile,
ISyncableListener,
ISonarListener,
IFlexibleGui<IDisplay> {
    default public int getInfoContainerID() {
        return this.getIdentity();
    }

    @Nullable
    public DisplayGSI getGSI();

    public void setGSI(DisplayGSI var1);

    public EnumFacing getCableFace();

    default public void onInfoContainerPacket() {
    }

    default public void onGSIValidate() {
    }

    default public void onGSIInvalidate() {
    }

    default public IDisplay getActualDisplay() {
        return this;
    }

    public Vec3d getScreenScaling();

    default public double getWidth() {
        return this.getScreenScaling().field_72450_a;
    }

    default public double getHeight() {
        return this.getScreenScaling().field_72448_b;
    }

    default public double getDepth() {
        return this.getScreenScaling().field_72449_c;
    }

    default public Vec3d getScreenRotation() {
        return DisplayVectorHelper.getScreenRotation(this.getCableFace());
    }

    default public double getPitch() {
        return this.getScreenRotation().field_72450_a;
    }

    default public double getYaw() {
        return this.getScreenRotation().field_72448_b;
    }

    default public double getRoll() {
        return this.getScreenRotation().field_72449_c;
    }

    default public Vec3d getScreenOrigin() {
        Vec3d pos = DisplayVectorHelper.convertVector((Vec3i)this.getCoords().getBlockPos());
        pos = pos.func_72441_c(0.5, 0.5, 0.5);
        pos = pos.func_178787_e(DisplayVectorHelper.getFaceOffset(this.getCableFace(), 0.5));
        return pos;
    }

    default public void onGuiOpened(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        this.getGSI().onGuiOpened(obj, id, world, player, tag);
    }

    default public Object getServerElement(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return this.getGSI().getServerElement(obj, id, world, player, tag);
    }

    default public Object getClientElement(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return this.getGSI().getClientElement(obj, id, world, player, tag);
    }
}

