/*
 * Decompiled with CFR 0.152.
 */
package io.sommers.packmode;

import io.sommers.packmode.api.PackModeAPI;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import joptsimple.internal.Strings;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PackModeCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "packmode";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/packmode <name> Sets the Packmode. Current valid packmodes are " + Strings.join(PackModeAPI.getInstance().getPackModes(), (String)" , ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            String newPackMode = args[0].trim();
            if (!PackModeAPI.getInstance().isValidPackMode(newPackMode)) throw new CommandException("PackMode " + newPackMode + " is not in the list of valid PackModes.", new Object[0]);
            PackModeAPI.getInstance().setNextRestartPackMode(newPackMode);
            sender.func_145747_a((ITextComponent)new TextComponentString("PackMode is now " + newPackMode + ". Please restart to enjoy the new PackMode."));
            return;
        } else {
            if (args.length != 0) throw new CommandException("Incorrect number of parameters requires 0 or 1, found " + args.length, new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentString("Current PackMode is " + PackModeAPI.getInstance().getCurrentPackMode() + ". PackMode next Restart will be " + PackModeAPI.getInstance().getNextRestartPackMode() + ". Valid  PackModes are " + Strings.join(PackModeAPI.getInstance().getPackModes(), (String)" , ")));
        }
    }
}

