/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.player;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import omtteam.omlib.handler.OMConfig;

public class Player {
    private final UUID uuid;
    private final String name;
    private String teamName = "";

    public Player(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.teamName = this.getTeamNameFromServer();
    }

    public Player(UUID uuid, String name, String teamName) {
        this.uuid = uuid;
        this.name = name;
        this.teamName = teamName;
    }

    public Player(EntityPlayer player) {
        this.uuid = player.func_110124_au();
        this.name = player.func_70005_c_();
        if (player.func_96124_cp() != null) {
            this.teamName = player.func_96124_cp().func_96661_b();
        }
    }

    public static void writeToByteBuf(Player player, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.getUuid().toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.getTeamName());
    }

    public static Player readFromByteBuf(ByteBuf buf) {
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        UUID uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        String teamUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        return new Player(uuid, name, teamUUID);
    }

    public static Player readFromNBT(NBTTagCompound tag) {
        return new Player(tag.func_186857_a("uuid"), tag.func_74779_i("name"), tag.func_74779_i("team_name"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_186854_a("uuid", this.uuid);
        if (!this.teamName.equalsIgnoreCase("")) {
            tag.func_74778_a("team_name", this.teamName);
        }
        return tag;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return !OMConfig.GENERAL.offlineModeSupport ? this.getUuid().equals(player.getUuid()) : this.getName().toLowerCase().equals(player.getName().toLowerCase());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + this.getName().toLowerCase().hashCode();
        return result;
    }

    @Nullable
    public EntityPlayer getEntityPlayer() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_184103_al().func_177451_a(this.uuid);
    }

    private String getTeamNameFromServer() {
        try {
            Team team;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null && server.func_184103_al().func_177451_a(this.uuid) != null && (team = server.func_184103_al().func_177451_a(this.uuid).func_96124_cp()) != null) {
                return team.func_96661_b();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

