/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.util;

import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.DimensionFunctions;
import com.natamus.collective.functions.NumberFunctions;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.collective.objects.RandomCollection;
import com.natamus.netherportalspread.config.ModConfig;
import com.natamus.netherportalspread.util.DefaultConfigs;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Util {
    public static HashMap<World, CopyOnWriteArrayList<BlockPos>> portals = new HashMap();
    public static HashMap<World, HashMap<BlockPos, Boolean>> preventedportals = new HashMap();
    private static HashMap<Block, HashMap<Block, Double>> convertinto = new HashMap();
    private static List<Block> convertblocks = new ArrayList<Block>();
    private static List<Block> convertedblocks = new ArrayList<Block>();
    private static Block preventSpreadBlock = null;

    public static void loadSpreadBlocks() throws IOException {
        String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "netherportalspread";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "spreadsettings.txt");
        if (dir.isDirectory() && file.isFile()) {
            String spreadsettings = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "spreadsettings.txt", new String[0])));
            spreadsettings = spreadsettings.replace("\n", "").replace("\r", "").replace(" ", "");
            for (String line : spreadsettings.split(",")) {
                ResourceLocation frl;
                if (line.length() < 4) {
                    System.out.println("The Nether Portal Spread spread settings contains an empty line. Ignoring it.");
                    continue;
                }
                String[] linespl = line.split(";");
                if (linespl.length != 2) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors. Ignoring it.");
                    continue;
                }
                String fromblockstr = linespl[0];
                if (!fromblockstr.contains(":")) {
                    fromblockstr = "minecraft:" + fromblockstr;
                }
                if (!ForgeRegistries.BLOCKS.containsKey(frl = new ResourceLocation(fromblockstr))) {
                    System.out.println("[Nether Portal Spread] Unable to find from-block '" + fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                Block fromblock = (Block)ForgeRegistries.BLOCKS.getValue(frl);
                String toblocks = linespl[1].replace("[", "").replace("]", "");
                double totalweight = 0.0;
                HashMap<Object, Double> tempmap = new HashMap<Object, Double>();
                for (String tb : toblocks.split("\\+")) {
                    String[] tbspl = tb.split(">");
                    if (tbspl.length < 2) continue;
                    String toblockstr = tbspl[0];
                    if (!toblockstr.contains(":")) {
                        toblockstr = "minecraft:" + toblockstr;
                    }
                    Double weight = 1.0;
                    try {
                        weight = Double.parseDouble(tbspl[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    totalweight += weight.doubleValue();
                    ResourceLocation trl = new ResourceLocation(toblockstr);
                    if (ForgeRegistries.BLOCKS.containsKey(trl)) {
                        tempmap.put(ForgeRegistries.BLOCKS.getValue(trl), weight);
                        continue;
                    }
                    System.out.println("[Nether Portal Spread] Unable to find to-block '" + toblockstr + "' in the Forge block registry. Ignoring it.");
                }
                if (tempmap.size() == 0 || totalweight == 0.0) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors, no convert blocks were found. Ignoring it.");
                    continue;
                }
                for (Block key : tempmap.keySet()) {
                    Double weightvalue = (Double)tempmap.get(key);
                    tempmap.put(key, 1.0 / totalweight * weightvalue);
                }
                convertinto.put(fromblock, tempmap);
            }
            for (Block b0 : convertinto.keySet()) {
                convertblocks.add(b0);
                for (Block b1 : convertinto.get(b0).keySet()) {
                    convertedblocks.add(b1);
                }
            }
        } else {
            dir.mkdirs();
            List<String> defaultconfig = DefaultConfigs.getDefaultConfigForVersion("[1.12.2]");
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "spreadsettings.txt", "UTF-8");
            for (String line : defaultconfig) {
                writer.println(line);
            }
            writer.close();
            Util.loadSpreadBlocks();
        }
        if (preventSpreadBlock == null) {
            String psbstr = ModConfig.preventSpreadBlockString;
            ResourceLocation psbrl = new ResourceLocation(psbstr);
            if (ForgeRegistries.BLOCKS.containsKey(psbrl)) {
                preventSpreadBlock = (Block)ForgeRegistries.BLOCKS.getValue(psbrl);
            } else {
                System.out.println("[Nether Portal Spread] Unable to get a prevent-spread-block from the string '" + psbstr + "'. Using the default coal block instead.");
                preventSpreadBlock = Blocks.field_150402_ci;
            }
        }
    }

    public static void loadPortalsFromWorld(World world) {
        String portalfolder = WorldFunctions.getWorldPath((WorldServer)((WorldServer)world)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String specificportalfolder = portalfolder + File.separator + DimensionFunctions.getSimpleDimensionString((World)world);
        if (specificportalfolder.endsWith("overworld")) {
            File[] files;
            File sourceDir = new File(portalfolder);
            File destinationDir = new File(specificportalfolder);
            destinationDir.mkdirs();
            for (File f : files = sourceDir.listFiles(pathname -> pathname.getName().endsWith(".portal"))) {
                Path sourcePath = Paths.get(sourceDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                Path destinationPath = Paths.get(destinationDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                try {
                    Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        File dir = new File(specificportalfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        int r = ModConfig.portalSpreadRadius;
        Integer psamount = ModConfig.preventSpreadBlockAmountNeeded;
        for (int i = 0; i < listOfFiles.length; ++i) {
            String[] cs;
            String filename = listOfFiles[i].getName();
            if (!filename.endsWith(".portal") || (cs = filename.replace(".portal", "").split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            BlockPos portal = new BlockPos(x, y, z);
            portals.get(world).add(portal);
            if (!ModConfig.preventSpreadWithBlock) continue;
            int coalcount = 0;
            Iterator it = BlockPos.func_191532_a((int)(portal.func_177958_n() - r), (int)(portal.func_177956_o() - r), (int)(portal.func_177952_p() - r), (int)(portal.func_177958_n() + r), (int)(portal.func_177956_o() + r), (int)(portal.func_177952_p() + r)).iterator();
            while (it.hasNext()) {
                try {
                    BlockPos np = (BlockPos)it.next();
                    if (!world.func_180495_p(np).func_177230_c().equals(preventSpreadBlock) || ++coalcount < psamount) continue;
                    break;
                }
                catch (NullPointerException ex) {
                }
            }
            if (coalcount >= psamount) {
                preventedportals.get(world).put(portal, true);
                continue;
            }
            preventedportals.get(world).put(portal, false);
        }
    }

    public static void savePortalToWorld(World world, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((WorldServer)((WorldServer)world)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals" + File.separator + DimensionFunctions.getSimpleDimensionString((World)world);
        File dir = new File(portalfolder);
        dir.mkdirs();
        String filename = portal.func_177958_n() + "_" + portal.func_177956_o() + "_" + portal.func_177952_p() + ".portal";
        try {
            PrintWriter writer = new PrintWriter(portalfolder + File.separator + filename, "UTF-8");
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while saving a portal location.");
        }
    }

    private static Boolean portalExists(World world, BlockPos pos) {
        for (BlockPos portalpos : portals.get(world)) {
            Double distance = pos.func_177954_c((double)portalpos.func_177958_n(), (double)portalpos.func_177956_o(), (double)portalpos.func_177952_p());
            if (!(distance < 10.0)) continue;
            return true;
        }
        return false;
    }

    public static void validatePortalAndAdd(World world, BlockPos p) {
        int netherblockcount;
        BlockPos rawportal = null;
        int r = 3;
        for (BlockPos nextpos : BlockPos.func_191532_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r))) {
            Block block = world.func_180495_p(nextpos).func_177230_c();
            if (!Util.isPortalBlock(block)) continue;
            rawportal = nextpos.func_185334_h();
            break;
        }
        if (rawportal == null) {
            return;
        }
        while (Util.isPortalBlock(world.func_180495_p(rawportal.func_177977_b()).func_177230_c())) {
            rawportal = rawportal.func_177977_b().func_185334_h();
        }
        while (Util.isPortalBlock(world.func_180495_p(rawportal.func_177976_e()).func_177230_c())) {
            rawportal = rawportal.func_177976_e().func_185334_h();
        }
        while (Util.isPortalBlock(world.func_180495_p(rawportal.func_177978_c()).func_177230_c())) {
            rawportal = rawportal.func_177978_c().func_185334_h();
        }
        if (portals.get(world).contains(rawportal) || preventedportals.get(world).containsKey(rawportal)) {
            return;
        }
        if (Util.portalExists(world, p).booleanValue()) {
            return;
        }
        Util.sendSpreadingMessage(world, p);
        preventedportals.get(world).put(p, false);
        portals.get(world).add(rawportal);
        Util.savePortalToWorld(world, rawportal);
        if (netherblockcount < ModConfig.instantConvertAmount) {
            for (netherblockcount = Util.countNetherBlocks(world, p); netherblockcount < ModConfig.instantConvertAmount && Util.spreadNextBlock(world, p).booleanValue(); ++netherblockcount) {
            }
        }
    }

    public static void removePortal(World world, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((WorldServer)((WorldServer)world)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String filename = portal.func_177958_n() + "_" + portal.func_177956_o() + "_" + portal.func_177952_p() + ".portal";
        File filepath = new File(portalfolder + File.separator + filename);
        try {
            Files.deleteIfExists(filepath.toPath());
        }
        catch (Exception ex) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while removing an old portal location.");
        }
        portals.get(world).remove(portal);
        preventedportals.get(world).remove(portal);
        Util.sendBrokenPortalMessage(world, portal);
    }

    public static Boolean spreadNextBlock(World world, BlockPos portal) {
        if (!world.func_72964_e(portal.func_177958_n() >> 4, portal.func_177952_p() >> 4).func_177410_o()) {
            return true;
        }
        IBlockState pbs = world.func_180495_p(portal);
        if (pbs == null) {
            return false;
        }
        if (!Util.isPortalBlock(pbs.func_177230_c())) {
            Util.removePortal(world, portal);
            return false;
        }
        int r = ModConfig.portalSpreadRadius;
        BlockPos closest = null;
        double nearestdistance = 100000.0;
        int coalcount = 0;
        Integer psamount = ModConfig.preventSpreadBlockAmountNeeded;
        Iterator it = BlockPos.func_191532_a((int)(portal.func_177958_n() - r), (int)(portal.func_177956_o() - r), (int)(portal.func_177952_p() - r), (int)(portal.func_177958_n() + r), (int)(portal.func_177956_o() + r), (int)(portal.func_177952_p() + r)).iterator();
        while (it.hasNext()) {
            try {
                BlockPos np = (BlockPos)it.next();
                if (ModConfig.preventSpreadWithBlock && world.func_180495_p(np).func_177230_c().equals(preventSpreadBlock) && ++coalcount >= psamount) break;
                double npnd = portal.func_177954_c((double)np.func_177958_n(), (double)np.func_177956_o(), (double)np.func_177952_p());
                if (!(npnd < nearestdistance) || !Util.isNetherTarget(world, np, false).booleanValue()) continue;
                nearestdistance = npnd;
                closest = np.func_185334_h();
            }
            catch (NullPointerException ex) {}
        }
        if (ModConfig.preventSpreadWithBlock && coalcount >= psamount) {
            boolean prevented = false;
            if (preventedportals.get(world).containsKey(portal)) {
                prevented = preventedportals.get(world).get(portal);
            }
            if (!prevented) {
                Util.sendPreventedMessage(world, portal);
            }
            preventedportals.get(world).put(portal, true);
            return true;
        }
        if (closest != null) {
            boolean prevented = false;
            if (preventedportals.get(world).containsKey(portal)) {
                prevented = preventedportals.get(world).get(portal);
            }
            if (prevented) {
                Util.sendSpreadingMessage(world, portal);
            }
            preventedportals.get(world).put(portal, false);
            Util.spreadNetherToBlock(world, closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(World world, BlockPos p) {
        int nethercount = 0;
        int r = ModConfig.portalSpreadRadius;
        for (BlockPos np : BlockPos.func_191532_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r))) {
            if (!Util.isNetherTarget(world, np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(World world, BlockPos pos, Boolean count) {
        if (world == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (count.booleanValue()) {
            if (convertedblocks.contains(block)) {
                return true;
            }
            return false;
        }
        if (convertblocks.contains(block)) {
            return true;
        }
        return false;
    }

    public static void spreadNetherToBlock(World world, BlockPos pos) {
        if (world == null) {
            return;
        }
        IBlockState newblockstate = null;
        IBlockState curstate = world.func_180495_p(pos);
        Block curblock = curstate.func_177230_c();
        if (convertblocks.contains(curblock)) {
            RandomCollection rc = new RandomCollection();
            HashMap<Block, Double> hashmap = convertinto.get(curblock);
            for (Block b0 : hashmap.keySet()) {
                Double weight = hashmap.get(b0);
                rc.add(weight * 100.0, (Object)b0);
            }
            newblockstate = ((Block)rc.next()).func_176223_P();
        }
        if (newblockstate != null) {
            world.func_175656_a(pos, newblockstate);
        }
    }

    private static boolean isPortalBlock(Block block) {
        return block instanceof BlockPortal || BlockFunctions.blockToReadableString((Block)block).equals("portal placeholder");
    }

    private static void sendSpreadingMessage(World world, BlockPos p) {
        if (!ModConfig.sendMessageOnPortalCreation) {
            return;
        }
        String message = ModConfig.messageOnPortalCreation;
        StringFunctions.sendMessageToPlayersAround((World)world, (BlockPos)p, (int)ModConfig.portalSpreadRadius, (String)Util.formatAroundString(message, ModConfig.preventSpreadBlockAmountNeeded, p), (TextFormatting)TextFormatting.RED);
    }

    private static void sendPreventedMessage(World world, BlockPos p) {
        if (!ModConfig.sendMessageOnPreventSpreadBlocksFound) {
            return;
        }
        String message = ModConfig.messageOnPreventSpreadBlocksFound;
        StringFunctions.sendMessageToPlayersAround((World)world, (BlockPos)p, (int)ModConfig.portalSpreadRadius, (String)Util.formatAroundString(message, ModConfig.preventSpreadBlockAmountNeeded, p), (TextFormatting)TextFormatting.DARK_GREEN);
    }

    private static void sendBrokenPortalMessage(World world, BlockPos p) {
        if (!ModConfig.sendMessageOnPortalBroken) {
            return;
        }
        String message = ModConfig.messageOnPortalBroken;
        StringFunctions.sendMessageToPlayersAround((World)world, (BlockPos)p, (int)ModConfig.portalSpreadRadius, (String)Util.formatAroundString(message, ModConfig.preventSpreadBlockAmountNeeded, p), (TextFormatting)TextFormatting.DARK_GREEN);
    }

    private static String formatAroundString(String message, int amountneeded, BlockPos portal) {
        if (preventSpreadBlock == null) {
            preventSpreadBlock = Blocks.field_150402_ci;
        }
        String blockstring = BlockFunctions.blockToReadableString((Block)preventSpreadBlock, (int)amountneeded);
        message = message.replace("%preventSpreadBlockString%", blockstring);
        message = message.replace("%preventSpreadBlockAmountNeeded%", amountneeded + "");
        message = message.replace("%portalSpreadRadius%", ModConfig.portalSpreadRadius + "");
        if (ModConfig.prefixPortalCoordsInMessage) {
            message = "Portal {" + portal.func_177958_n() + ", " + portal.func_177956_o() + ", " + portal.func_177952_p() + "}: " + message;
        }
        return message;
    }
}

