/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.events;

import com.natamus.collective.functions.WorldFunctions;
import com.natamus.netherportalspread.config.ModConfig;
import com.natamus.netherportalspread.util.Util;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class SpreadEvent {
    private static HashMap<World, CopyOnWriteArrayList<BlockPos>> portals_to_process = new HashMap();
    private static HashMap<World, Integer> worldticks = new HashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        int worldtick;
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (WorldFunctions.isNether((World)world)) {
            return;
        }
        if (portals_to_process.get(world).size() > 0) {
            BlockPos portal = portals_to_process.get(world).get(0);
            if (!Util.portals.get(world).contains(portal) && !Util.preventedportals.get(world).containsKey(portal)) {
                Util.validatePortalAndAdd(world, portal);
            }
            portals_to_process.get(world).remove(0);
        }
        if ((worldtick = worldticks.get(world).intValue()) % ModConfig.spreadDelayTicks != 0) {
            worldticks.put(world, worldtick + 1);
            return;
        }
        worldticks.put(world, 1);
        for (BlockPos portal : Util.portals.get(world)) {
            Util.spreadNextBlock(world, portal);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (WorldFunctions.isNether((World)world)) {
            return;
        }
        worldticks.put(world, 0);
        portals_to_process.put(world, new CopyOnWriteArrayList());
        Util.portals.put(world, new CopyOnWriteArrayList());
        Util.preventedportals.put(world, new HashMap());
        Util.loadPortalsFromWorld(world);
    }

    @SubscribeEvent
    public void onPortalSpawn(BlockEvent.PortalSpawnEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (WorldFunctions.isNether((World)world)) {
            return;
        }
        BlockPos portalpos = e.getPos();
        portals_to_process.get(world).add(portalpos);
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        EntityPlayer player = e.player;
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (WorldFunctions.isNether((World)world)) {
            return;
        }
        BlockPos ppos = player.func_180425_c();
        portals_to_process.get(world).add(ppos);
    }
}

