/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="netherportalspread")
@Config.LangKey(value="Nether Portal Spread Config")
public class ModConfig {
    @Config.Comment(value={"When enabled, sends a message to players around the portal that the nether is spreading and that you can stop the spread with 'preventSpreadBlockAmountNeeded' of the 'preventSpreadBlockString' block."})
    public static boolean sendMessageOnPortalCreation = true;
    @Config.Comment(value={"The message sent on portal creation."})
    public static String messageOnPortalCreation = "You feel a corrupted energy coming from the portal. The nether will slowly spread into the overworld unless %preventSpreadBlockAmountNeeded% %preventSpreadBlockString% are placed within a %portalSpreadRadius% block radius around the portal.";
    @Config.Comment(value={"When enabled, sends a message to players around the portal that the nether spread has stopped when the portal detects new 'preventSpreadBlockString' blocks."})
    public static boolean sendMessageOnPreventSpreadBlocksFound = true;
    @Config.Comment(value={"The message sent on preventspread blocks found."})
    public static String messageOnPreventSpreadBlocksFound = "With enough %preventSpreadBlockString% placed, you feel the corrupted energy fade.";
    @Config.Comment(value={"When enabled, sends a message to players around the portal when it is broken."})
    public static boolean sendMessageOnPortalBroken = true;
    @Config.Comment(value={"The message sent when a portal is broken."})
    public static String messageOnPortalBroken = "With the nether portal broken, the corrupted energy is no longer able to enter the overworld.";
    @Config.Comment(value={"When enabled, shows the portal coordinates in portal messages."})
    public static boolean prefixPortalCoordsInMessage = true;
    @Config.Comment(value={"The radius around the portal to which the nether blocks can spread."})
    @Config.RangeInt(min=1, max=100)
    public static int portalSpreadRadius = 30;
    @Config.Comment(value={"The delay in ticks in between the spread around the nether portal. 20 ticks = 1 second."})
    @Config.RangeInt(min=1, max=72000)
    public static int spreadDelayTicks = 40;
    @Config.Comment(value={"The amount of blocks that are instantly converted to a nether block around a portal when it is detected. If there are existing nether blocks within the radius, their count is substracted from this number."})
    @Config.RangeInt(min=0, max=1000)
    public static int instantConvertAmount = 50;
    @Config.Comment(value={"When enabled, blocks the spread effect when there are n (defined) prevent-spread-blocks (defined) within the radius."})
    public static boolean preventSpreadWithBlock = true;
    @Config.Comment(value={"The amount of prevent-spread-blocks (defined) needed within the radius of the nether portal to prevent spread."})
    public static int preventSpreadBlockAmountNeeded = 4;
    @Config.Comment(value={"The block which prevents the nether portal from spreading. By default a coal block (minecraft:coal_block is the namespace ID)."})
    public static String preventSpreadBlockString = "minecraft:coal_block";

    @Mod.EventBusSubscriber(modid="netherportalspread")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("netherportalspread")) {
                ConfigManager.sync((String)"netherportalspread", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

