/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.property.power;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleFallingBlock;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.property.MowziePlayerProperties;
import com.bobmowzie.mowziesmobs.server.property.power.Power;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PowerGeomancy
extends Power {
    private int doubleTapTimer = 0;
    protected Random rand;
    private int spawnBoulderCooldown = 10;
    private boolean spawningBoulder = false;
    private boolean liftedMouse = true;
    private int spawnBoulderCharge = 0;
    private BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    private Vec3d lookPos = new Vec3d(0.0, 0.0, 0.0);
    private IBlockState spawnBoulderBlock = Blocks.field_150346_d.func_176223_P();
    public boolean tunneling;
    public boolean prevUnderground;
    public IBlockState justDug = Blocks.field_150346_d.func_176223_P();

    public PowerGeomancy(MowziePlayerProperties properties) {
        super(properties);
        this.rand = new Random();
    }

    @Override
    public void onUpdate(TickEvent.PlayerTickEvent event) {
        super.onUpdate(event);
        EntityPlayer player = event.player;
        --this.spawnBoulderCooldown;
        if (this.doubleTapTimer > 0) {
            --this.doubleTapTimer;
        }
        if (this.tunneling) {
            EntityRing ring;
            boolean underground;
            player.field_70143_R = 0.0f;
            player.field_71075_bZ.field_75100_b = false;
            boolean bl = underground = !player.field_70170_p.func_72872_a(EntityBlockSwapper.class, player.func_174813_aQ()).isEmpty();
            if (player.field_70122_E && !underground) {
                this.tunneling = false;
            }
            Vec3d lookVec = player.func_70040_Z();
            float tunnelSpeed = 0.9f;
            if (underground) {
                if (player.func_70093_af()) {
                    player.field_70159_w = (double)tunnelSpeed * lookVec.field_72450_a;
                    player.field_70181_x = (double)tunnelSpeed * lookVec.field_72448_b;
                    player.field_70179_y = (double)tunnelSpeed * lookVec.field_72449_c;
                } else {
                    player.field_70159_w = (double)tunnelSpeed * 0.5 * lookVec.field_72450_a;
                    player.field_70181_x = 1.0;
                    player.field_70179_y = (double)tunnelSpeed * 0.5 * lookVec.field_72449_c;
                }
                List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(4.0, 4.0, 4.0, 4.0);
                for (EntityLivingBase entityHit : entitiesHit) {
                    entityHit.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 6.0f * ConfigHandler.TOOLS_AND_ABILITIES.geomancyAttackMultiplier);
                }
            } else {
                player.field_70181_x -= 0.07;
            }
            if (player.func_70093_af() && lookVec.field_72448_b < 0.0 || underground) {
                if (player.field_70173_aa % 16 == 0) {
                    player.func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_RUMBLE.get(this.rand.nextInt(3))).get(), 0.6f, 0.5f + this.rand.nextFloat() * 0.2f);
                }
                for (double x = -1.5; x <= 1.5; x += 1.0) {
                    for (double y = -1.5; y <= 2.0; y += 1.0) {
                        for (double z = -1.5; z <= 2.0; z += 1.0) {
                            BlockPos pos;
                            IBlockState blockState;
                            if (Math.sqrt(x * x + y * y + z * z) > 2.0 || !this.isBlockDiggable(blockState = player.field_70170_p.func_180495_p(pos = new BlockPos(player.field_70165_t + x + player.field_70159_w, player.field_70163_u + y + player.field_70181_x + 0.5, player.field_70161_v + z + player.field_70179_y))) || blockState.func_177230_c() == Blocks.field_150357_h) continue;
                            this.justDug = blockState;
                            EntityBlockSwapper.swapBlock(player.field_70170_p, pos, Blocks.field_150350_a.func_176223_P(), 10, false, false);
                        }
                    }
                }
            }
            if (!this.prevUnderground && underground) {
                player.func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM.get(this.rand.nextInt(3))).get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
                ring = new EntityRing(player.field_70170_p, (float)player.field_70165_t, (float)player.field_70163_u + 0.02f, (float)player.field_70161_v, new Vec3d(0.0, 1.0, 0.0), 10, 0.83f, 1.0f, 0.39f, 1.0f, 3.0f, false);
                player.field_70170_p.func_72838_d((Entity)ring);
            }
            if (this.prevUnderground && !underground) {
                player.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK, 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
                ring = new EntityRing(player.field_70170_p, (float)player.field_70165_t, (float)player.field_70163_u + 0.02f, (float)player.field_70161_v, new Vec3d(0.0, 1.0, 0.0), 10, 0.83f, 1.0f, 0.39f, 1.0f, 3.0f, false);
                player.field_70170_p.func_72838_d((Entity)ring);
                player.field_70159_w *= 2.0;
                player.field_70181_x *= 2.0;
                player.field_70179_y *= 2.0;
                if (player.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 6; ++i) {
                        if (this.justDug == null) {
                            this.justDug = Blocks.field_150346_d.func_176223_P();
                        }
                        ParticleFallingBlock.spawnFallingBlock(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 30.0f, 80, 1.0f, player.func_70681_au().nextFloat() * 0.8f - 0.4f, 0.4f + player.func_70681_au().nextFloat() * 0.8f, player.func_70681_au().nextFloat() * 0.8f - 0.4f, ParticleFallingBlock.EnumScaleBehavior.CONSTANT, this.justDug);
                    }
                }
            }
            this.prevUnderground = underground;
        }
        if (this.spawningBoulder) {
            if (player.func_70011_f((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) > 6.0 || !this.canUse(player)) {
                this.spawningBoulder = false;
                this.spawnBoulderCharge = 0;
            } else {
                ++this.spawnBoulderCharge;
                if (this.spawnBoulderCharge > 2) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 0, 2, false, false));
                }
                if (this.spawnBoulderCharge == 1 && player.field_70170_p.field_72995_K) {
                    MowziesMobs.PROXY.playBoulderChargeSound(player);
                }
                if ((this.spawnBoulderCharge + 10) % 10 == 0 && this.spawnBoulderCharge < 40) {
                    EntityRing ring = new EntityRing(player.field_70170_p, (float)player.field_70165_t, (float)player.field_70163_u + player.field_70131_O / 2.0f, (float)player.field_70161_v, new Vec3d(0.0, 1.0, 0.0), 10, 0.83f, 1.0f, 0.39f, 0.7f, 0.8f + 2.7f * (float)this.spawnBoulderCharge / 60.0f, false){

                        @Override
                        public float interpolate(float delta) {
                            return 1.0f - ((float)this.field_70173_aa + delta) / (float)this.duration;
                        }
                    };
                    if (player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)ring);
                    }
                }
                if (this.spawnBoulderCharge == 50) {
                    EntityRing ring = new EntityRing(player.field_70170_p, (float)player.field_70165_t, (float)player.field_70163_u + player.field_70131_O / 2.0f, (float)player.field_70161_v, new Vec3d(0.0, 1.0, 0.0), 20, 0.83f, 1.0f, 0.39f, 0.7f, 4.0f, true);
                    if (player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)ring);
                    }
                    player.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.0f, 1.0f);
                }
                if (player.field_70170_p.field_72995_K && this.spawnBoulderCharge > 5 && this.spawnBoulderCharge < 30) {
                    int particleCount = 4;
                    while (--particleCount != 0) {
                        double radius = 0.5f + 1.5f * (float)this.spawnBoulderCharge / 30.0f;
                        double yaw = (double)(player.func_70681_au().nextFloat() * 2.0f) * Math.PI;
                        double pitch = (double)(player.func_70681_au().nextFloat() * 2.0f) * Math.PI;
                        double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        double oy = radius * Math.cos(pitch);
                        double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        MMParticle.ORB.spawn(player.field_70170_p, player.field_70165_t + ox, player.field_70163_u + oy + (double)(player.field_70131_O / 2.0f), player.field_70161_v + oz, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, 14));
                    }
                }
            }
            if (this.spawnBoulderCharge > 60) {
                this.spawnBoulder(player);
                this.liftedMouse = false;
            }
        }
    }

    @Override
    public void onRightMouseUp(EntityPlayer player) {
        super.onRightMouseUp(player);
        this.liftedMouse = true;
        if (this.spawningBoulder && player.func_70011_f((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) < 6.0) {
            this.spawnBoulder(player);
        } else {
            this.spawningBoulder = false;
            this.spawnBoulderCharge = 0;
        }
    }

    @Override
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        super.onRightClickBlock(event);
        EntityPlayer player = event.getEntityPlayer();
        if (event.getHand() == EnumHand.MAIN_HAND && this.canUse(player) && event.getHitVec() != null && !this.tunneling && !this.spawningBoulder && this.liftedMouse && this.spawnBoulderCooldown <= 0) {
            IBlockState blockAbove;
            this.lookPos = new Vec3d(event.getHitVec().field_72450_a, event.getHitVec().field_72448_b, event.getHitVec().field_72449_c);
            this.spawnBoulderPos = event.getPos();
            this.spawnBoulderBlock = player.field_70170_p.func_180495_p(this.spawnBoulderPos);
            if (event.getFace() != EnumFacing.UP && ((blockAbove = player.field_70170_p.func_180495_p(this.spawnBoulderPos.func_177984_a())).func_191058_s() || blockAbove == Blocks.field_150350_a.func_176223_P())) {
                return;
            }
            if (!this.isBlockDiggable(this.spawnBoulderBlock)) {
                return;
            }
            this.spawningBoulder = true;
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        EntityPlayer player = event.getEntityPlayer();
    }

    @Override
    public void onSneakDown(EntityPlayer player) {
        super.onSneakDown(player);
        if (this.doubleTapTimer > 0 && this.canUse(player) && !player.field_70122_E) {
            this.tunneling = true;
        }
        this.doubleTapTimer = 8;
    }

    @Override
    public void onSneakUp(EntityPlayer player) {
        super.onSneakUp(player);
    }

    public boolean isSpawningBoulder() {
        return this.spawningBoulder;
    }

    public BlockPos getSpawnBoulderPos() {
        return this.spawnBoulderPos;
    }

    public Vec3d getLookPos() {
        return this.lookPos;
    }

    private void spawnBoulder(EntityPlayer player) {
        int size = (int)Math.min(Math.max(0.0, Math.floor((float)this.spawnBoulderCharge / 10.0f) - 1.0), 2.0);
        if (this.spawnBoulderCharge >= 60) {
            size = 3;
        }
        EntityBoulder boulder = new EntityBoulder(player.field_70170_p, (EntityLivingBase)player, size, this.spawnBoulderBlock);
        boulder.func_70107_b((float)this.spawnBoulderPos.func_177958_n() + 0.5f, this.spawnBoulderPos.func_177956_o() + 2, (float)this.spawnBoulderPos.func_177952_p() + 0.5f);
        if (!player.field_70170_p.field_72995_K && boulder.checkCanSpawn()) {
            player.field_70170_p.func_72838_d((Entity)boulder);
        }
        this.spawnBoulderCooldown = 10;
        this.spawnBoulderCharge = 0;
        this.spawningBoulder = false;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return player.func_184614_ca().func_190926_b() && player.func_70644_a((Potion)PotionHandler.GEOMANCY);
    }

    public int getSpawnBoulderCharge() {
        return this.spawnBoulderCharge;
    }

    public boolean isBlockDiggable(IBlockState blockState) {
        Material mat = blockState.func_185904_a();
        if (mat != Material.field_151577_b && mat != Material.field_151578_c && mat != Material.field_151576_e && mat != Material.field_151571_B && mat != Material.field_151595_p) {
            return false;
        }
        return blockState != Blocks.field_150407_cf && blockState.func_177230_c() != Blocks.field_189878_dg && !(blockState.func_177230_c() instanceof BlockFence) && blockState.func_177230_c() != Blocks.field_150474_ac && blockState.func_177230_c() != Blocks.field_189880_di && blockState.func_177230_c() != Blocks.field_150381_bn && blockState.func_177230_c() != Blocks.field_150378_br && blockState.func_177230_c() != Blocks.field_150477_bB && blockState.func_177230_c() != Blocks.field_180399_cE;
    }
}

