/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class MMPathFinder
extends PathFinder {
    private final PathHeap path = new PathHeap();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;

    public MMPathFinder(NodeProcessor processor) {
        super(processor);
        this.nodeProcessor = processor;
    }

    @Nullable
    public Path func_186333_a(IBlockAccess worldIn, EntityLiving living, Entity targetEntity, float maxDistance) {
        return this.findPath(worldIn, living, targetEntity.field_70165_t, targetEntity.func_174813_aQ().field_72338_b, targetEntity.field_70161_v, maxDistance);
    }

    @Nullable
    public Path func_186336_a(IBlockAccess worldIn, EntityLiving living, BlockPos targetPos, float maxDistance) {
        return this.findPath(worldIn, living, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, maxDistance);
    }

    @Nullable
    private Path findPath(IBlockAccess worldIn, EntityLiving living, double x, double y, double z, float maxDistance) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(worldIn, living);
        PathPoint start = this.nodeProcessor.func_186318_b();
        PathPoint end = this.nodeProcessor.func_186325_a(x, y, z);
        Path path = this.findPath(start, end, maxDistance);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(PathPoint pathFrom, PathPoint pathTo, float maxDistance) {
        pathFrom.field_75836_e = 0.0f;
        pathFrom.field_75834_g = pathFrom.field_75833_f = pathFrom.func_186281_c(pathTo);
        this.path.func_75848_a();
        this.path.func_75849_a(pathFrom);
        PathPoint pathpoint = pathFrom;
        int attempts = 0;
        while (!this.path.func_75845_e() && ++attempts < 200) {
            PathPoint point = this.path.func_75844_c();
            if (point.equals((Object)pathTo)) {
                pathpoint = pathTo;
                break;
            }
            if (point.func_186281_c(pathTo) < pathpoint.func_186281_c(pathTo)) {
                pathpoint = point;
            }
            point.field_75842_i = true;
            int found = this.nodeProcessor.func_186320_a(this.pathOptions, point, pathTo, maxDistance);
            for (int i = 0; i < found; ++i) {
                PathPoint p = this.pathOptions[i];
                float dist = point.func_186281_c(p);
                p.field_186284_j = point.field_186284_j + dist;
                p.field_186285_k = dist + p.field_186286_l;
                float totalDistance = point.field_75836_e + p.field_186285_k;
                if (!(p.field_186284_j < maxDistance) || p.func_75831_a() && !(totalDistance < p.field_75836_e)) continue;
                p.field_75841_h = point;
                p.field_75836_e = totalDistance;
                p.field_75833_f = p.func_186281_c(pathTo) + p.field_186286_l;
                if (p.func_75831_a()) {
                    this.path.func_75850_a(p, p.field_75836_e + p.field_75833_f);
                    continue;
                }
                p.field_75834_g = p.field_75836_e + p.field_75833_f;
                this.path.func_75849_a(p);
            }
        }
        if (pathpoint == pathFrom) {
            return null;
        }
        return this.createPath(pathFrom, pathpoint);
    }

    private Path createPath(PathPoint start, PathPoint end) {
        int i = 1;
        PathPoint p = end;
        while (p.field_75841_h != null) {
            ++i;
            p = p.field_75841_h;
        }
        PathPoint[] points = new PathPoint[i];
        PathPoint p2 = end;
        points[--i] = end;
        while (p2.field_75841_h != null) {
            p2 = p2.field_75841_h;
            points[--i] = p2;
        }
        return new PatchedPath(points);
    }

    static class PatchedPath
    extends Path {
        public PatchedPath(PathPoint[] pathpoints) {
            super(pathpoints);
        }

        public Vec3d func_75881_a(Entity entity, int index) {
            PathPoint point = this.func_75877_a(index);
            double d0 = (double)point.field_75839_a + (double)MathHelper.func_76141_d((float)(entity.field_70130_N + 1.0f)) * 0.5;
            double d1 = point.field_75837_b;
            double d2 = (double)point.field_75838_c + (double)MathHelper.func_76141_d((float)(entity.field_70130_N + 1.0f)) * 0.5;
            return new Vec3d(d0, d1, d2);
        }
    }
}

