/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ParticleOrb
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private double targetX;
    private double targetY;
    private double targetZ;
    private double startX;
    private double startY;
    private double startZ;
    private double signX;
    private double signZ;
    private float red;
    private float green;
    private float blue;
    private int mode;
    private double duration;

    public ParticleOrb(World world, double x, double y, double z, double targetX, double targetZ) {
        super(world, x, y, z);
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.field_70544_f = 4.5f + this.field_187136_p.nextFloat() * 1.5f;
        this.field_70547_e = 120;
        this.signX = Math.signum(targetX - this.field_187126_f);
        this.signZ = Math.signum(targetZ - this.field_187128_h);
        this.mode = 0;
        this.field_82339_as = 0.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
    }

    public ParticleOrb(World world, double x, double y, double z, double targetX, double targetY, double targetZ, double speed) {
        this(world, x, y, z, targetX, targetZ);
        this.targetY = targetY;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.duration = speed;
        this.mode = 1;
        this.field_82339_as = 0.1f;
    }

    public ParticleOrb(World world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, double scale, int duration) {
        super(world, x, y, z);
        this.field_70544_f = (float)scale * 1.0f;
        this.field_70547_e = duration;
        this.duration = duration;
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.mode = 2;
    }

    public int func_70537_b() {
        return 1;
    }

    public int func_189214_a(float delta) {
        return 0xF0 | super.func_189214_a(delta) & 0xFF0000;
    }

    public void func_189213_a() {
        this.field_82339_as = 0.1f;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.mode == 0) {
            double vecX = this.targetX - this.field_187126_f;
            double vecZ = this.targetZ - this.field_187128_h;
            double dist = Math.sqrt(vecX * vecX + vecZ * vecZ);
            if (dist > 2.0 || Math.signum(vecX) != this.signX || Math.signum(vecZ) != this.signZ || this.field_70546_d > this.field_70547_e) {
                this.func_187112_i();
                return;
            }
            double peak = 0.5;
            this.field_82339_as = (float)(dist > 0.5 ? MathUtils.linearTransformd(dist, 0.5, 2.0, 1.0, 0.0) : MathUtils.linearTransformd(dist, 0.1f, 0.5, 0.0, 1.0));
            double minVel = 0.05;
            double maxVel = 0.3;
            double progress = Math.sin(-0.7853981633974483 * dist) + 1.0;
            double magMultipler = (progress * 0.25 + 0.05) / dist;
            this.field_187129_i = vecX *= magMultipler;
            this.field_187130_j = progress;
            this.field_187131_k = vecZ *= magMultipler;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        } else if (this.mode == 1) {
            this.field_82339_as = (float)this.field_70546_d / (float)this.duration;
            this.field_187126_f = this.startX + (this.targetX - this.startX) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_187127_g = this.startY + (this.targetY - this.startY) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_187128_h = this.startZ + (this.targetZ - this.startZ) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            if ((double)this.field_70546_d == this.duration) {
                this.func_187112_i();
            }
        } else if (this.mode == 2) {
            super.func_189213_a();
            if (this.field_70546_d >= this.field_70547_e) {
                this.func_187112_i();
            }
        }
        ++this.field_70546_d;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.field_82339_as = this.mode == 2 ? Math.max(1.0f - ((float)this.field_70546_d + partialTicks) / (float)this.duration, 0.001f) : ((float)this.field_70546_d + partialTicks) / (float)this.duration;
        this.field_70552_h = this.red;
        this.field_70553_i = this.green;
        this.field_70551_j = this.blue;
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public boolean func_187111_c() {
        return true;
    }

    public static final class OrbFactory
    extends ParticleFactory<OrbFactory, ParticleOrb> {
        public OrbFactory() {
            super(ParticleOrb.class, ParticleTextureStitcher.create(ParticleOrb.class, new ResourceLocation("mowziesmobs", "particles/orb")));
        }

        @Override
        public ParticleOrb createParticle(ParticleFactory.ImmutableParticleArgs args) {
            if (args.data.length == 2) {
                return new ParticleOrb(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1]);
            }
            if (args.data.length == 4) {
                return new ParticleOrb(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], ((Number)args.data[3]).doubleValue());
            }
            return new ParticleOrb(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], (Double)args.data[4], (Double)args.data[5], (Double)args.data[6], (Integer)args.data[7]);
        }
    }
}

