/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.sounds.FarmerSounds;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.farmer.EntityAIWorkFarmer;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobFarmer
extends AbstractJob {
    public JobFarmer(ICitizenData entity) {
        super(entity);
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.farmer;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Farmer";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.FARMER;
    }

    @Override
    @NotNull
    public AbstractAISkeleton<JobFarmer> generateAI() {
        return new EntityAIWorkFarmer(this);
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.hostile : null;
        }
        return null;
    }
}

