/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.util.StudyItem;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuildingWorker {
    private static final String STUDENT = "Student";
    private static final String LIBRARY_HUT_NAME = "Library";
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Random random = new Random();
    private final List<StudyItem> studyItems = this.parseFromConfig();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
    }

    private List<StudyItem> parseFromConfig() {
        ArrayList<StudyItem> studyItemList = new ArrayList<StudyItem>();
        for (String entry : Configurations.gameplay.configListStudyItems) {
            try {
                String[] entries = entry.split(";");
                if (entries.length < 3) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(entries[0]));
                int skillChance = Integer.parseInt(entries[1]);
                int breakChance = Integer.parseInt(entries[2]);
                if (item == null || skillChance < 100 || skillChance > 1000 || breakChance > 100 || breakChance < 0) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                studyItemList.add(new StudyItem(item, skillChance, breakChance));
                this.keepX.put(itemStack -> itemStack.func_77973_b() == item, new Tuple((Object)(breakChance < 5 ? 5 : breakChance), (Object)true));
            }
            catch (ClassCastException | NumberFormatException e) {
                Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry + " Exception:" + e.getMessage());
            }
        }
        return studyItemList;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return STUDENT;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobStudent(citizen);
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c("bookcase", 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.bookCases.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList bookcaseTagList = new NBTTagList();
        for (BlockPos entry : this.bookCases) {
            NBTTagCompound bookCompound = new NBTTagCompound();
            bookCompound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            bookcaseTagList.func_74742_a((NBTBase)bookCompound);
        }
        compound.func_74782_a("bookcase", (NBTBase)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockBookshelf) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() instanceof BlockBookshelf) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    public List<StudyItem> getStudyItems() {
        return this.studyItems;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.library;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingLibrary.LIBRARY_HUT_NAME);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel() * 2;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }
    }
}

