/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EnchantmentHelper
extends net.minecraft.enchantment.EnchantmentHelper {
    public static List<EnchantmentData> getEnchantmentsFromItem(ItemStack item) {
        if (!item.func_77948_v()) {
            return null;
        }
        final ArrayList<EnchantmentData> ret = new ArrayList<EnchantmentData>();
        net.minecraft.enchantment.EnchantmentHelper.func_82781_a((ItemStack)item).forEach(new BiConsumer<Enchantment, Integer>(){

            @Override
            public void accept(Enchantment ench, Integer lvl) {
                ret.add(new EnchantmentData(ench, lvl.intValue()));
            }
        });
        return ret;
    }

    public static List<EnchantmentData> getEnchantmentsFromBook(ItemStack enchantedBook) {
        if (enchantedBook.func_77973_b() != Items.field_151134_bR) {
            throw new RuntimeException("Attempted to retrieve enchantments on an ItemStack that isn't a book!");
        }
        ArrayList<EnchantmentData> ret = new ArrayList<EnchantmentData>();
        NBTTagList enchantmentsRaw = enchantedBook.func_77986_q();
        for (int i = 0; i < enchantmentsRaw.func_74745_c(); ++i) {
            NBTTagCompound enchantRaw = enchantmentsRaw.func_150305_b(i);
            ret.add(new EnchantmentData(Enchantment.func_185262_c((int)enchantRaw.func_74765_d("id")), (int)enchantRaw.func_74765_d("lvl")));
        }
        return ret;
    }

    public static boolean removeEnchantment(EnchantmentData ench, ItemStack item) {
        boolean flag = false;
        for (int i = 0; i < item.func_77986_q().func_74745_c(); ++i) {
            EnchantmentData enchantmentData = new EnchantmentData(Enchantment.func_185262_c((int)item.func_77986_q().func_150305_b(i).func_74765_d("id")), (int)item.func_77986_q().func_150305_b(i).func_74765_d("lvl"));
            if (enchantmentData.field_76302_b != ench.field_76302_b) continue;
            if (ench.field_76303_c < enchantmentData.field_76303_c) {
                NBTTagCompound tag = item.func_77986_q().func_150305_b(i);
                tag.func_74777_a("lvl", (short)(enchantmentData.field_76303_c - ench.field_76303_c));
                item.func_77986_q().func_150304_a(i, (NBTBase)tag);
                flag = true;
                continue;
            }
            if (ench.field_76303_c != enchantmentData.field_76303_c) continue;
            item.func_77986_q().func_74744_a(i);
            flag = true;
        }
        if (item.func_77986_q().func_74745_c() == 0) {
            item.func_77978_p().func_82580_o("ench");
        }
        return flag;
    }

    public static ItemStack getEnchantedBookWithEnchants(List<EnchantmentData> ench) {
        final ItemStack ret = new ItemStack(Items.field_151134_bR, 1, 0);
        ench.forEach(new Consumer<EnchantmentData>(){

            @Override
            public void accept(EnchantmentData enchantmentData) {
                ret.func_77966_a(enchantmentData.field_76302_b, enchantmentData.field_76303_c);
            }
        });
        return ret;
    }
}

