/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.config.sync;

import com.mattdahepic.mdecore.config.sync.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Property;

final class Range<T extends Number> {
    public static final Range<Double> MAX_RANGE = Range.of(Double.MIN_VALUE, Double.MAX_VALUE);
    public final T min;
    public final T max;

    public static <T extends Number> Range<T> of(T min, T max) {
        return new Range<T>(min, max);
    }

    public static Range<Double> of(Config.Range rangeAnnot) {
        return new Range<Double>(rangeAnnot.min(), rangeAnnot.max());
    }

    private Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public T clamp(T value) {
        return ((Number)value).doubleValue() < ((Number)this.min).doubleValue() ? this.min : (((Number)value).doubleValue() > ((Number)this.max).doubleValue() ? this.max : value);
    }

    public List<T> clampArr(List<T> value) {
        ArrayList<Number> ret = new ArrayList<Number>(value.size());
        for (int i = 0; i < value.size(); ++i) {
            ret.add(i, this.clamp((Number)value.get(i)));
        }
        return ret;
    }

    public void apply(Property p) {
        if (this.equals(MAX_RANGE)) {
            return;
        }
        if (p.getType() == Property.Type.INTEGER) {
            Range<Integer> r = Range.of(((Number)this.min).intValue(), ((Number)this.max).intValue());
            p.setMinValue(((Integer)r.min).intValue());
            p.setMaxValue(((Integer)r.max).intValue());
        } else if (p.getType() == Property.Type.DOUBLE) {
            Range<Double> r = Range.of(((Number)this.min).doubleValue(), ((Number)this.max).doubleValue());
            p.setMinValue(((Double)r.min).doubleValue());
            p.setMaxValue(((Double)r.max).doubleValue());
        } else {
            throw new IllegalArgumentException(String.format("A mod tried to set range %s on a property that was not either of Integer of Double type.", this));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        return other.min.equals(this.min) && other.max.equals(this.max);
    }

    public String toString() {
        return "Range(min=" + this.min + ", max=" + this.max + ")";
    }
}

