/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.config.sync;

import com.google.common.base.Throwables;
import com.mattdahepic.mdecore.MDECore;
import com.mattdahepic.mdecore.config.sync.ConfigProcessor;
import com.mattdahepic.mdecore.config.sync.ConfigSyncable;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConfigSync
implements IMessage {
    private Map<String, Object> configValues;
    private String configName;

    public PacketConfigSync() {
    }

    public PacketConfigSync(ConfigProcessor toSync) {
        this.configValues = toSync.currentValues;
        this.configName = toSync.configFileName;
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            ObjectOutputStream objStream = new ObjectOutputStream(gzip);
            objStream.writeObject(this.configValues);
            objStream.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.configName);
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        try {
            ObjectInputStream obj = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
            this.configValues = (Map)obj.readObject();
            obj.close();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.configName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, IMessage> {
        public IMessage onMessage(PacketConfigSync msg, MessageContext ctx) {
            ConfigProcessor processor = ConfigProcessor.processorMap.get(msg.configName);
            if (processor != null) {
                MDECore.logger.debug("Received config synchronization packet from server for config " + processor.configFileName + ".cfg. Setting values accordingly...");
                processor.syncTo(msg.configValues);
                MinecraftForge.EVENT_BUS.post((Event)new ConfigSyncable.ConfigSyncEvent(msg.configName));
            }
            return null;
        }
    }
}

