/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.config.sync;

import com.mattdahepic.mdecore.config.sync.ConfigProcessor;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class ConfigSyncable {
    private final String configFileName;
    public Configuration config;
    private static ConfigSyncable instance;

    public abstract String getConfigVersion();

    public abstract String getConfigName();

    public abstract Class<? extends ConfigSyncable> getConfigClass();

    public static ConfigSyncable instance() {
        if (instance == null) {
            throw new RuntimeException(String.format("Config instance is null, instantiate and initialize first!", new Object[0]));
        }
        return instance;
    }

    protected ConfigSyncable() {
        instance = this;
        this.configFileName = this.getConfigName();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public final void initalize(FMLPreInitializationEvent e) {
        this.config = new Configuration(new File(e.getModConfigurationDirectory().getAbsolutePath() + File.separator + "mattdahepic" + File.separator + this.configFileName + ".cfg"), this.getConfigVersion());
        ConfigProcessor processor = new ConfigProcessor(this.getConfigClass(), this.config, this.configFileName);
        processor.process(true);
    }

    public static class ConfigSyncEvent
    extends Event {
        public final String configName;

        public ConfigSyncEvent(String configName) {
            this.configName = configName;
        }
    }
}

