/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command.logic;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.ICommandLogic;
import com.mattdahepic.mdecore.helpers.TickrateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TickrateLogic
implements ICommandLogic {
    public static TickrateLogic instance = new TickrateLogic();

    @Override
    public String getCommandName() {
        return "tickrate";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandSyntax() {
        return "/mde tickrate <tickrate> <all|server|client|player name>";
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + String.format("Client: %ftps | Server: %dtps", Float.valueOf(TickrateHelper.getClientTickrate()), TickrateHelper.getServerTickrate())));
            return;
        }
        try {
            float inputTicks = Float.parseFloat(args[1]);
            if (!TickrateHelper.isTickrateValid(inputTicks)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid tickrate, must be greater than 0. You can't just go around stopping time!"));
                return;
            }
            if (args.length == 2 || args[2].equals("all")) {
                TickrateHelper.setTickrate(server, inputTicks);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + String.format("Tickrate changed to %dtps.", Float.valueOf(inputTicks))));
            } else if (args[2].equals("server")) {
                TickrateHelper.setServerTickrate(inputTicks);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + String.format("Server tickrate changed to %dtps.", Float.valueOf(inputTicks))));
            } else if (args[2].equals("client")) {
                TickrateHelper.setAllClientTickrate(server, inputTicks);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + String.format("All connected players tickrate set to %dtps.", Float.valueOf(inputTicks))));
            } else {
                EntityPlayerMP p = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                TickrateHelper.setClientTickrate((EntityPlayer)p, inputTicks);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + String.format("%s's client tickrate set to %dtps.", p.func_70005_c_(), Float.valueOf(inputTicks))));
            }
        }
        catch (NumberFormatException ne) {
            AbstractCommand.throwInvalidNumber(args[1]);
        }
        catch (Exception ex) {
            throw new CommandException("Something went wrong! Try again.", new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> tab = new ArrayList<String>();
        if (args.length == 2) {
            tab.add("0.01");
            tab.add("0.5");
            tab.add("1");
            tab.add("2");
            tab.add("5");
            tab.add("10");
            tab.add("20");
            tab.add("50");
            tab.add("100");
            tab.add("200");
            tab.add("500");
            tab.add("1000");
        } else if (args.length == 3) {
            tab.add("all");
            tab.add("server");
            tab.add("client");
            tab.addAll(Arrays.asList(server.func_184103_al().func_72369_d()));
        } else {
            tab = null;
        }
        return tab;
    }
}

