/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command.logic;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.AbstractSingleLogicCommand;
import com.mattdahepic.mdecore.helpers.TeleportHelper;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;

public class TPXLogic
extends AbstractSingleLogicCommand {
    public static TPXLogic instance = new TPXLogic();

    @Override
    public String getCommandName() {
        return "tpx";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandSyntax() {
        return "/mde tpx [player] {(<player> | <dimension>) | <x> <y> <z> [dimension]}";
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        switch (args.length) {
            case 1: {
                AbstractCommand.throwUsages(instance);
            }
            case 2: {
                EntityPlayerMP playerSender = CommandBase.func_71521_c((ICommandSender)sender);
                try {
                    EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    if (!player.equals((Object)playerSender)) {
                        if (playerSender.field_71093_bK == player.field_71093_bK) {
                            player.func_70634_a(playerSender.field_70165_t, playerSender.field_70163_u, playerSender.field_70161_v);
                            break;
                        }
                        TeleportHelper.transferPlayerToDimension(player, playerSender.field_71093_bK, playerSender.field_71133_b.func_184103_al());
                        player.func_70634_a(playerSender.field_70165_t, playerSender.field_70163_u, playerSender.field_70161_v);
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "Don't teleport yourself!"));
                }
                catch (PlayerNotFoundException t) {
                    int dimension = 0;
                    try {
                        dimension = Integer.parseInt(args[1]);
                    }
                    catch (Exception e) {
                        throw t;
                    }
                    if (!DimensionManager.isDimensionRegistered((int)dimension)) {
                        AbstractCommand.throwNoWorld();
                    }
                    if (playerSender.field_71093_bK != dimension) {
                        TeleportHelper.transferPlayerToDimension(playerSender, dimension, playerSender.field_71133_b.func_184103_al());
                    }
                    TeleportHelper.sendPlayerToSpawnInCurrentWorld((ICommandSender)playerSender);
                }
                break;
            }
            case 3: {
                EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                try {
                    EntityPlayerMP otherPlayer = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                    if (!player.equals((Object)otherPlayer)) {
                        if (otherPlayer.field_71093_bK == player.field_71093_bK) {
                            player.func_70634_a(otherPlayer.field_70165_t, otherPlayer.field_70163_u, otherPlayer.field_70161_v);
                            break;
                        }
                        TeleportHelper.transferPlayerToDimension(player, otherPlayer.field_71093_bK, otherPlayer.field_71133_b.func_184103_al());
                        player.func_70634_a(otherPlayer.field_70165_t, otherPlayer.field_70163_u, otherPlayer.field_70161_v);
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Don't teleport to yourself!"));
                }
                catch (PlayerNotFoundException t) {
                    int dimension = 0;
                    try {
                        dimension = Integer.parseInt(args[2]);
                    }
                    catch (Exception e) {
                        throw t;
                    }
                    if (!DimensionManager.isDimensionRegistered((int)dimension)) {
                        AbstractCommand.throwNoWorld();
                    }
                    if (player.field_71093_bK != dimension) {
                        TeleportHelper.transferPlayerToDimension(player, dimension, player.field_71133_b.func_184103_al());
                    }
                    TeleportHelper.sendPlayerToSpawnInCurrentWorld((ICommandSender)player);
                }
                break;
            }
            case 4: {
                EntityPlayerMP playerSender = CommandBase.func_71521_c((ICommandSender)sender);
                try {
                    playerSender.func_70634_a((double)Integer.parseInt(args[1]), (double)Integer.parseInt(args[2]), (double)Integer.parseInt(args[3]));
                }
                catch (NumberFormatException e) {
                    AbstractCommand.throwInvalidNumber(e.getMessage().substring(e.getMessage().indexOf(34) + 1, e.getMessage().length() - 1));
                }
                break;
            }
            case 5: {
                try {
                    EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    try {
                        player.func_70634_a((double)Integer.parseInt(args[2]), (double)Integer.parseInt(args[3]), (double)Integer.parseInt(args[4]));
                    }
                    catch (NumberFormatException e) {
                        AbstractCommand.throwInvalidNumber(e.getMessage().substring(e.getMessage().indexOf(34) + 1, e.getMessage().length() - 1));
                    }
                }
                catch (PlayerNotFoundException t) {
                    int dimension;
                    try {
                        dimension = Integer.parseInt(args[4]);
                    }
                    catch (Exception e) {
                        throw t;
                    }
                    EntityPlayerMP playerSender = CommandBase.func_71521_c((ICommandSender)sender);
                    if (!DimensionManager.isDimensionRegistered((int)dimension)) {
                        AbstractCommand.throwNoWorld();
                    }
                    if (playerSender.field_71093_bK != dimension) {
                        TeleportHelper.transferPlayerToDimension(playerSender, dimension, playerSender.field_71133_b.func_184103_al());
                    }
                    playerSender.func_70634_a(playerSender.field_70165_t, playerSender.field_70163_u, playerSender.field_70161_v);
                }
                break;
            }
            default: {
                EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                int dimension = Integer.parseInt(args[5]);
                if (!DimensionManager.isDimensionRegistered((int)dimension)) {
                    AbstractCommand.throwNoWorld();
                }
                if (player.field_71093_bK != dimension) {
                    TeleportHelper.transferPlayerToDimension(player, dimension, player.field_71133_b.func_184103_al());
                }
                try {
                    player.func_70634_a((double)Integer.parseInt(args[2]), (double)Integer.parseInt(args[3]), (double)Integer.parseInt(args[4]));
                    break;
                }
                catch (NumberFormatException e) {
                    AbstractCommand.throwInvalidNumber(e.getMessage().substring(e.getMessage().indexOf(34) + 1, e.getMessage().length() - 1));
                }
            }
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2 || args.length == 3) {
            return AbstractCommand.getPlayerNamesStartingWithLastArg(server, args);
        }
        if (args.length >= 6) {
            Integer[] ids = DimensionManager.getIDs();
            String[] strings = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                strings[i] = ids[i].toString();
            }
            return CommandBase.func_71530_a((String[])args, (String[])strings);
        }
        return null;
    }
}

