/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command.logic;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.AbstractSingleLogicCommand;
import com.mattdahepic.mdecore.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class TPSLogic
extends AbstractSingleLogicCommand {
    public static TPSLogic instance = new TPSLogic();

    @Override
    public String getCommandName() {
        return "tps";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public String getCommandSyntax() {
        return "/mde tps [{o | a | <dimension>}]";
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            double tps = WorldHelper.getTps(server, null);
            double tickms = WorldHelper.getTickMs(server, null);
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Overall: %.2f TPS/%.2fMS (%s%%)", tps, tickms, (int)(tps / 20.0 * 100.0))));
            for (WorldServer world : server.field_71305_c) {
                tps = WorldHelper.getTps(server, (World)world);
                tickms = WorldHelper.getTickMs(server, (World)world);
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%s [%d]: %.2f TPS/%.2fMS (%d%%)", world.func_175624_G().func_77127_a(), world.field_73011_w.getDimension(), tps, tickms, (int)(tps / 20.0 * 100.0))));
            }
        } else if (args[1].toLowerCase().charAt(0) == 'o') {
            double tickms = WorldHelper.getTickMs(server, null);
            double tps = WorldHelper.getTps(server, null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Overall server tick"));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("TPS: %.2f TPS of %.2f TPS (%d%%)", tps, 20L, (int)(tps / 20.0 * 100.0))));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Tick time: %.2f ms of %.2f ms.", tickms, 50L)));
        } else if (args[1].toLowerCase().charAt(0) == 'a') {
            double tickms = WorldHelper.getTickMs(server, null);
            double tps = WorldHelper.getTps(server, null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Overall server tick"));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("TPS: %.2f TPS of %.2f TPS (%d%%)", tps, 20L, (int)(tps / 20.0 * 100.0))));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Tick time: %.2f ms of %.2f ms.", tickms, 50L)));
            int loadedChunks = 0;
            int entities = 0;
            int te = 0;
            int worlds = 0;
            for (WorldServer world : server.field_71305_c) {
                loadedChunks += ((ChunkProviderServer)world.func_72863_F()).func_73152_e();
                entities += world.field_72996_f.size();
                te += world.field_147482_g.size();
                ++worlds;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Total Loaded Worlds/Chunks: %d/%d", worlds, loadedChunks)));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Total Entities/TileEntities: %d/%d", entities, te)));
        } else {
            try {
                int dim = Integer.parseInt(args[1]);
                WorldServer world = server.func_71218_a(dim);
                if (world == null) {
                    AbstractCommand.throwNoWorld();
                }
                double tickms = WorldHelper.getTickMs(server, (World)world);
                double tps = WorldHelper.getTps(server, (World)world);
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("World %s: %s - Loaded chunks: %d", world.field_73011_w.getDimension(), world.func_175624_G().func_77127_a(), ((ChunkProviderServer)world.func_72863_F()).func_73152_e())));
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("TPS: %.2f/%.2f TPS (%d%%) - Tick: %.2f ms of %.2f ms", tps, 20L, (int)(tps / 20.0 * 100.0), tickms, 50L)));
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Entities: %d - Tile Entities: %d", world.field_72996_f.size(), world.field_147482_g.size())));
            }
            catch (NumberFormatException e) {
                AbstractCommand.throwInvalidNumber(args[1]);
            }
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2 || args.length == 3) {
            ArrayList<String> worldIDs = new ArrayList<String>();
            worldIDs.add("o");
            worldIDs.add("a");
            for (WorldServer world : server.field_71305_c) {
                worldIDs.add(Integer.toString(world.field_73011_w.getDimension()));
            }
            return CommandBase.func_71530_a((String[])args, (String[])worldIDs.toArray(new String[]{""}));
        }
        return null;
    }
}

