/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.maxpotidext;

import java.util.ListIterator;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import zabi.minecraft.maxpotidext.ASMException;
import zabi.minecraft.maxpotidext.CodeSnippets;
import zabi.minecraft.maxpotidext.Log;
import zabi.minecraft.maxpotidext.Obf;

public class MPIDTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode cn;
        ClassReader cr;
        if (transformedName.equals("net.minecraft.client.network.NetHandlerPlayClient")) {
            return this.transformNetHandlerPlayClient(basicClass);
        }
        if (transformedName.equals("net.minecraft.potion.PotionEffect")) {
            return this.transformPotionEffect(basicClass);
        }
        if (transformedName.equals("net.minecraftforge.registries.GameData")) {
            return this.transformGameData(basicClass);
        }
        if (transformedName.equals("net.minecraft.network.play.server.SPacketEntityEffect")) {
            return this.transformSPacketEntityEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.network.play.server.SPacketRemoveEntityEffect")) {
            return this.transformSPacketRemoveEntityEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.nbt.NBTTagCompound")) {
            cr = new ClassReader(basicClass);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (!cn.name.equals(Obf.NBTTagCompound)) {
                throw new ASMException("The class NBTTagCompound has broken mappings, should be " + cn.name);
            }
        }
        if (transformedName.equals("net.minecraft.network.PacketBuffer")) {
            cr = new ClassReader(basicClass);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (!cn.name.equals(Obf.PacketBuffer)) {
                throw new ASMException("The class PacketBuffer has broken mappings, should be " + cn.name);
            }
        }
        return basicClass;
    }

    private static MethodNode locateMethod(ClassNode cn, String desc, String nameIn, String deobfNameIn) {
        return cn.methods.stream().filter(n -> n.desc.equals(desc) && (n.name.equals(nameIn) || n.name.equals(deobfNameIn))).findAny().orElseThrow(() -> new ASMException(nameIn + " (" + deobfNameIn + "): " + desc + " cannot be found in " + cn.name, cn));
    }

    private static AbstractInsnNode locateTargetInsn(MethodNode mn, Predicate<AbstractInsnNode> filter) {
        AbstractInsnNode target = null;
        ListIterator i = mn.instructions.iterator();
        while (i.hasNext() && target == null) {
            AbstractInsnNode n = (AbstractInsnNode)i.next();
            if (!filter.test(n)) continue;
            target = n;
        }
        if (target == null) {
            throw new ASMException("Can't locate target instruction in " + mn.name, mn);
        }
        return target;
    }

    private byte[] transformSPacketRemoveEntityEffect(byte[] basicClass) {
        Log.i("Patching SPacketRemoveEntityEffect");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        String descriptors = "(L" + Obf.PacketBuffer + ";)V";
        MethodNode rpd = MPIDTransformer.locateMethod(cn, descriptors, "readPacketData", "a");
        AbstractInsnNode target = MPIDTransformer.locateTargetInsn(rpd, n -> n.getOpcode() == 182 && ((MethodInsnNode)n).name.equals("readUnsignedByte"));
        rpd.instructions.insert(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, "readInt", "()I", false));
        rpd.instructions.remove(target);
        MethodNode wpd = MPIDTransformer.locateMethod(cn, descriptors, "writePacketData", "b");
        target = MPIDTransformer.locateTargetInsn(wpd, n -> n.getOpcode() == 182 && ((MethodInsnNode)n).name.equals("writeByte"));
        wpd.instructions.insert(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, "writeInt", "(I)Lio/netty/buffer/ByteBuf;", false));
        wpd.instructions.remove(target);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        Log.i("Patch Successful");
        return cw.toByteArray();
    }

    private byte[] transformSPacketEntityEffect(byte[] basicClass) {
        Log.i("Patching SPacketEntityEffect");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (!Obf.SPacketEntityEffect.equals(cn.name)) {
            throw new ASMException("Mapping mismatch! SPacketEntityEffect is " + cn.name + ", not " + Obf.SPacketEntityEffect);
        }
        cn.fields.add(new FieldNode(1, "effectInt", "I", null, (Object)0));
        MethodNode mn_init = MPIDTransformer.locateMethod(cn, "(IL" + Obf.PotionEffect + ";)V", "<init>", "<init>");
        ListIterator i = mn_init.instructions.iterator();
        AbstractInsnNode targetNode = null;
        int line = 0;
        while (i.hasNext() && targetNode == null) {
            AbstractInsnNode node = (AbstractInsnNode)i.next();
            if (!(node instanceof LineNumberNode)) continue;
            if (line == 1) {
                targetNode = node;
            }
            ++line;
        }
        if (targetNode == null) {
            throw new ASMException("Can't find target node for SPacketEntityEffect constructor");
        }
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(CodeSnippets.class), "getIdFromPotEffect", "(L" + Obf.PotionEffect + ";)I", false));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new VarInsnNode(25, 2));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
        MethodNode mn_empty_init = MPIDTransformer.locateMethod(cn, "()V", "<init>", "<init>");
        AbstractInsnNode tgt = MPIDTransformer.locateTargetInsn(mn_empty_init, n -> n.getOpcode() == 177);
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new LdcInsnNode((Object)0));
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        MethodNode mn_readPacket = MPIDTransformer.locateMethod(cn, "(L" + Obf.PacketBuffer + ";)V", "readPacketData", "a");
        String readVarInt_name = Obf.isDeobf() ? "readVarInt" : "g";
        AbstractInsnNode target = MPIDTransformer.locateTargetInsn(mn_readPacket, n -> n.getOpcode() == 177).getPrevious().getPrevious();
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new VarInsnNode(25, 1));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, readVarInt_name, "()I", false));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        MethodNode mn_writePacket = MPIDTransformer.locateMethod(cn, "(L" + Obf.PacketBuffer + ";)V", "writePacketData", "b");
        String writeVarInt_name = Obf.isDeobf() ? "writeVarInt" : "d";
        AbstractInsnNode wp_target = MPIDTransformer.locateTargetInsn(mn_writePacket, n -> n.getOpcode() == 177).getPrevious().getPrevious();
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new VarInsnNode(25, 1));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new FieldInsnNode(180, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, writeVarInt_name, "(I)L" + Obf.PacketBuffer + ";", false));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new InsnNode(87));
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        Log.i("Patch Successful");
        return cw.toByteArray();
    }

    private byte[] transformGameData(byte[] basicClass) {
        Log.i("Patching GameData");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        FieldNode mpid = cn.fields.stream().filter(fn -> fn.name.equals("MAX_POTION_ID")).findAny().orElseThrow(() -> new ASMException("Error finding MAX_POTION_ID constant in GameData.class"));
        cn.fields.remove(mpid);
        cn.fields.add(new FieldNode(mpid.access, mpid.name, mpid.desc, mpid.signature, (Object)0x1FFFFFFF));
        MethodNode mn = MPIDTransformer.locateMethod(cn, "()V", "init", "init");
        AbstractInsnNode target = MPIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 17 && n.getPrevious().getOpcode() == 18 && Obf.isPotionClass(((LdcInsnNode)n.getPrevious()).cst.toString()));
        mn.instructions.insert(target, (AbstractInsnNode)new LdcInsnNode((Object)0x1FFFFFFF));
        mn.instructions.remove(target);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        Log.i("Patch Successful");
        return cw.toByteArray();
    }

    private byte[] transformPotionEffect(byte[] basicClass) {
        Log.i("Patching PotionEffect");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (!cn.name.equals(Obf.PotionEffect)) {
            throw new ASMException("Mapping mismatch! PotionEffect is " + cn.name + ", not " + Obf.PotionEffect);
        }
        MethodNode mn = MPIDTransformer.locateMethod(cn, "(L" + Obf.NBTTagCompound + ";)L" + Obf.NBTTagCompound + ";", "writeCustomPotionEffectToNBT", "a");
        AbstractInsnNode ant = MPIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 145);
        String mname = Obf.isDeobf() ? "setInteger" : "a";
        MethodInsnNode call = new MethodInsnNode(182, Obf.NBTTagCompound, mname, "(Ljava/lang/String;I)V", false);
        mn.instructions.remove(ant.getNext());
        mn.instructions.insert(ant, (AbstractInsnNode)call);
        mn.instructions.remove(ant);
        MethodNode mn2 = MPIDTransformer.locateMethod(cn, "(L" + Obf.NBTTagCompound + ";)L" + Obf.PotionEffect + ";", "readCustomPotionEffectFromNBT", "b");
        AbstractInsnNode ant2 = MPIDTransformer.locateTargetInsn(mn2, n -> n.getOpcode() == 182);
        String name2 = Obf.isDeobf() ? "getInteger" : "h";
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.insert(ant2, (AbstractInsnNode)new MethodInsnNode(182, Obf.NBTTagCompound, name2, "(Ljava/lang/String;)I", false));
        mn2.instructions.remove(ant2);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        Log.i("Patch Successful");
        return cw.toByteArray();
    }

    private byte[] transformNetHandlerPlayClient(byte[] basicClass) {
        Log.i("Patching NetHandlerPlayClient");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = MPIDTransformer.locateMethod(cn, "(L" + Obf.SPacketEntityEffect + ";)V", "handleEntityEffect", "a");
        AbstractInsnNode target = MPIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 17);
        mn.instructions.remove(target.getPrevious());
        mn.instructions.remove(target.getNext());
        mn.instructions.insertBefore(target, (AbstractInsnNode)new FieldInsnNode(180, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn.instructions.remove(target);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        Log.i("Patch Successful");
        return cw.toByteArray();
    }
}

