/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.malisis.core.asm.AsmHook;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.asm.CustomClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class MalisisClassTransformer
implements IClassTransformer {
    public Multimap<String, AsmHook> listHooks = HashMultimap.create();
    protected String logString = "malisiscore";
    protected Logger log;

    public MalisisClassTransformer() {
        this.registerHooks();
    }

    public void register(AsmHook ah) {
        ah.setTransformer(this.getClass().getSimpleName());
        this.listHooks.put((Object)ah.getTargetClass(), (Object)ah);
        LogManager.getLogger((String)this.logString).info("[{}] Hook registered for {}", (Object)ah.getTransformer(), (Object)ah.getTargetClass());
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Collection hooks = this.listHooks.get((Object)transformedName);
        if (hooks == null || hooks.size() == 0) {
            return bytes;
        }
        LogManager.getLogger((String)this.logString).info("Found hooks for {} ({})", (Object)transformedName, (Object)name);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (AsmHook hook : hooks) {
            MethodNode methodNode = AsmUtils.findMethod(classNode, hook.getMethodName(), hook.getMethodDescriptor());
            if (methodNode != null) {
                if (!hook.walkSteps(methodNode)) {
                    LogManager.getLogger((String)this.logString).error("[{}] The instruction list was not found in {}:{}{}", (Object)hook.getTransformer(), (Object)hook.getTargetClass(), (Object)hook.getMethodName(), (Object)hook.getMethodDescriptor());
                }
                if (!hook.isDebug() || !((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) continue;
                System.err.println(AsmUtils.getMethodNodeAsString(methodNode));
                continue;
            }
            LogManager.getLogger((String)this.logString).error("[{}] Method not found : {}:{}{}", (Object)hook.getTransformer(), (Object)hook.getTargetClass(), (Object)hook.getMethodName(), (Object)hook.getMethodDescriptor());
        }
        CustomClassWriter writer = new CustomClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public abstract void registerHooks();
}

