/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.malisis.core.registry.AutoLoad;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad
public class MalisisCommand
extends CommandBase {
    private Set<String> parameters = Sets.newHashSet();
    private static Map<String, Runnable> debugs = Maps.newHashMap();

    public MalisisCommand() {
        ClientCommandHandler.instance.func_71560_a((ICommand)this);
        this.parameters.add("config");
        this.parameters.add("version");
        this.parameters.add("debug");
    }

    public static void registerDebug(String name, Runnable command) {
        debugs.put(name, command);
    }

    public String func_71517_b() {
        return "malisis";
    }

    public String func_71518_a(ICommandSender sender) {
        return "malisiscore.commands.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) throws CommandException {
        if (params.length == 0) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        if (!this.parameters.contains(params[0])) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        switch (params[0]) {
            case "config": {
                this.configCommand(sender, params);
                break;
            }
            case "version": {
                IMalisisMod mod = null;
                if (params.length == 1) {
                    mod = MalisisCore.instance;
                } else {
                    mod = MalisisCore.getMod(params[1]);
                    if (mod == null) {
                        MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
                    }
                }
                if (mod == null) break;
                MalisisCore.message("malisiscore.commands.modversion", mod.getName(), mod.getVersion());
                break;
            }
            case "debug": {
                this.debugCommand(sender, params);
                break;
            }
            default: {
                MalisisCore.message("Not yet implemented");
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] params, BlockPos pos) {
        if (params.length == 1) {
            return MalisisCommand.func_175762_a((String[])params, this.parameters);
        }
        if (params.length == 2 && params[0].equals("debug")) {
            return MalisisCommand.func_175762_a((String[])params, debugs.keySet());
        }
        if (params.length == 2) {
            return MalisisCommand.func_175762_a((String[])params, MalisisCore.listModId());
        }
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void configCommand(ICommandSender sender, String[] params) {
        MalisisCore mod;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MalisisCore.log.warn("Can't open configuration GUI on a dedicated server.");
            return;
        }
        IMalisisMod iMalisisMod = mod = params.length == 1 ? MalisisCore.instance : MalisisCore.getMod(params[1]);
        if (mod == null) {
            MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
            return;
        }
        if (!MalisisCore.openConfigurationGui(mod)) {
            MalisisCore.message("malisiscore.commands.noconfiguration", mod.getName());
        }
    }

    public void debugCommand(ICommandSender sender, String[] params) {
        if (params.length != 2) {
            MalisisCore.message("malisiscore.commands.debugparammissing");
            return;
        }
        Runnable runnable = debugs.get(params[1]);
        if (runnable == null) {
            MalisisCore.message("malisiscore.commands.debugnotfound", params[1]);
            return;
        }
        runnable.run();
    }
}

