/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public class JsonTransfer {
    public static Set<String> findResources(String filepath, Set<String> fileNames) {
        HashSet<String> files = new HashSet<String>();
        for (String name : fileNames) {
            String str = filepath + "/" + name + ".json";
            files.add(str);
        }
        return files;
    }

    public static void copyResource(String from, Path to, boolean overwrite) {
        try {
            if (overwrite || !Files.exists(to, new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.copy(JsonTransfer.getResourcesAsStream(from), to, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static InputStream getResourcesAsStream(String location) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + location);
        return in != null ? in : JsonTransfer.class.getResourceAsStream("/" + location);
    }
}

