/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.MyrmexHive;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class MyrmexWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_myrmex";
    private final List<BlockPos> villagerPositionsList = Lists.newArrayList();
    private final List<MyrmexHive> hiveList = Lists.newArrayList();
    private World world;
    private int tickCounter;

    public MyrmexWorldData(String name) {
        super(name);
    }

    public MyrmexWorldData(World world) {
        super(IDENTIFIER);
        this.world = world;
        this.func_76185_a();
    }

    public static MyrmexWorldData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        MyrmexWorldData instance = (MyrmexWorldData)storage.func_75742_a(MyrmexWorldData.class, IDENTIFIER);
        if (instance == null) {
            instance = new MyrmexWorldData(world);
            storage.func_75745_a(IDENTIFIER, (WorldSavedData)instance);
        }
        instance.func_76185_a();
        return instance;
    }

    public static void addHive(World world, MyrmexHive hive) {
        MyrmexWorldData.get((World)world).hiveList.add(hive);
    }

    public void setWorldsForAll(World worldIn) {
        this.world = worldIn;
        for (MyrmexHive village : this.hiveList) {
            village.setWorld(worldIn);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (MyrmexHive hive : this.hiveList) {
            hive.tick(this.tickCounter, this.world);
        }
    }

    private void removeAnnihilatedHives() {
        Iterator<MyrmexHive> iterator = this.hiveList.iterator();
        while (iterator.hasNext()) {
            MyrmexHive village = iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List<MyrmexHive> getHivelist() {
        return this.hiveList;
    }

    public MyrmexHive getNearestHive(BlockPos doorBlock, int radius) {
        MyrmexHive village = null;
        double d0 = 3.4028234663852886E38;
        for (MyrmexHive village1 : this.hiveList) {
            float f;
            double d1 = village1.getCenter().func_177951_i((Vec3i)doorBlock);
            if (!(d1 < d0) || !(d1 <= (double)((f = (float)(radius + village1.getVillageRadius())) * f))) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private boolean positionInList(BlockPos pos) {
        for (BlockPos blockpos : this.villagerPositionsList) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public void debug() {
        for (MyrmexHive hive : this.hiveList) {
            IceAndFire.logger.debug((Object)hive);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        NBTTagList nbttaglist = nbt.func_150295_c("Hives", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            MyrmexHive village = new MyrmexHive();
            village.readVillageDataFromNBT(nbttagcompound);
            this.hiveList.add(village);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglist = new NBTTagList();
        for (MyrmexHive village : this.hiveList) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            village.writeVillageDataToNBT(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Hives", (NBTBase)nbttaglist);
        return compound;
    }

    public MyrmexHive getHiveFromUUID(UUID id) {
        for (MyrmexHive hive : this.hiveList) {
            if (hive.hiveUUID == null || !hive.hiveUUID.equals(id)) continue;
            return hive;
        }
        return null;
    }
}

