/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageMultipartInteract
extends AbstractMessage<MessageMultipartInteract> {
    public int creatureID;
    public float dmg;

    public MessageMultipartInteract(int creatureID, float dmg) {
        this.creatureID = creatureID;
        this.dmg = dmg;
    }

    public MessageMultipartInteract() {
    }

    public void fromBytes(ByteBuf buf) {
        this.creatureID = buf.readInt();
        this.dmg = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.creatureID);
        buf.writeFloat(this.dmg);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, MessageMultipartInteract message, EntityPlayer player, MessageContext messageContext) {
        Entity entity;
        if (player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.creatureID)) != null && entity instanceof EntityLivingBase) {
            double dist = player.func_70032_d(entity);
            EntityLivingBase mob = (EntityLivingBase)entity;
            if (dist < 100.0) {
                if (message.dmg > 0.0f) {
                    mob.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.dmg);
                } else {
                    mob.func_184230_a(player, EnumHand.MAIN_HAND);
                }
            }
        }
    }

    public void onServerReceived(MinecraftServer server, MessageMultipartInteract message, EntityPlayer player, MessageContext messageContext) {
        Entity entity;
        if (player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.creatureID)) != null && entity instanceof EntityLivingBase) {
            double dist = player.func_70032_d(entity);
            EntityLivingBase mob = (EntityLivingBase)entity;
            if (dist < 100.0) {
                if (message.dmg > 0.0f) {
                    mob.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.dmg);
                } else {
                    mob.func_184230_a(player, EnumHand.MAIN_HAND);
                }
            }
        }
    }
}

