/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class DragonAIAttackMelee
extends EntityAIBase {
    protected EntityDragonBase dragon;
    private int attackTick;
    private double speedTowardsTarget;
    private boolean longMemory;
    private Path entityPathEntity;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public DragonAIAttackMelee(EntityDragonBase dragon, double speedIn, boolean useLongMemory) {
        this.dragon = dragon;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.dragon.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.dragon.canMove() || this.dragon.isHovering() || this.dragon.isFlying()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.entityPathEntity = this.dragon.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 4 + this.dragon.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        this.entityPathEntity = this.dragon.func_70661_as().func_75494_a((Entity)entitylivingbase);
        return this.entityPathEntity != null;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.dragon.func_70638_az();
        if (entitylivingbase != null && entitylivingbase.field_70128_L) {
            this.func_75251_c();
            return false;
        }
        return entitylivingbase != null && entitylivingbase.func_70089_S() && (!this.longMemory ? this.dragon.isFlying() || this.dragon.isHovering() || !this.dragon.func_70661_as().func_75500_f() : this.dragon.func_180485_d(new BlockPos((Entity)entitylivingbase)) && (!(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_()));
    }

    public void func_75249_e() {
        this.dragon.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.dragon.func_70638_az();
        if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
            this.dragon.func_70624_b(null);
        }
        this.dragon.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entity = this.dragon.func_70638_az();
        if (entity != null) {
            if (!this.dragon.func_184196_w((Entity)entity)) {
                this.dragon.func_70671_ap().func_75651_a((Entity)entity, 30.0f, 30.0f);
            }
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                this.func_75251_c();
                return;
            }
            double d0 = this.dragon.func_70092_e(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
            double d1 = this.getAttackReachSqr(entity);
            --this.delayCounter;
            if ((this.longMemory || this.dragon.func_70635_at().func_75522_a((Entity)entity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.dragon.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = entity.field_70165_t;
                this.targetY = entity.func_174813_aQ().field_72338_b;
                this.targetZ = entity.field_70161_v;
                this.delayCounter = 4 + this.dragon.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.dragon.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.dragon.func_70661_as().func_75505_d().func_75870_c()) != null && entity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.dragon.func_70661_as().func_75497_a((Entity)entity, this.speedTowardsTarget) && this.dragon.canMove()) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick <= 0) {
                this.attackTick = 20;
                this.dragon.func_184609_a(EnumHand.MAIN_HAND);
                this.dragon.func_70652_k((Entity)entity);
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.dragon.field_70130_N * 2.0f * this.dragon.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

