/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelAmphithere;
import com.github.alexthe666.iceandfire.client.model.ModelCockatrice;
import com.github.alexthe666.iceandfire.client.model.ModelCyclops;
import com.github.alexthe666.iceandfire.client.model.ModelHippogryph;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.model.ModelStymphalianBird;
import com.github.alexthe666.iceandfire.client.model.ModelTroll;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityMobSkull;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMobSkull
extends Render<EntityMobSkull> {
    private static final Map<String, ResourceLocation> SKULL_TEXTURE_CACHE = Maps.newHashMap();
    private ModelHippogryph hippogryphModel = new ModelHippogryph();
    private ModelCyclops cyclopsModel = new ModelCyclops();
    private ModelCockatrice cockatriceModel = new ModelCockatrice();
    private ModelStymphalianBird stymphalianBirdModel = new ModelStymphalianBird();
    private ModelTroll trollModel = new ModelTroll();
    private ModelAmphithere amphithereModel = new ModelAmphithere();
    private ModelHydraHead hydraModel;
    private IceAndFireTabulaModel seaSerpentModel;

    public RenderMobSkull(RenderManager renderManager, ModelBase seaSerpentModel) {
        super(renderManager);
        this.seaSerpentModel = (IceAndFireTabulaModel)seaSerpentModel;
        this.hydraModel = new ModelHydraHead(0);
    }

    private static void setRotationAngles(ModelRenderer cube, float rotX, float rotY, float rotZ) {
        cube.field_78795_f = rotX;
        cube.field_78796_g = rotY;
        cube.field_78808_h = rotZ;
    }

    public void doRender(EntityMobSkull entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179114_b((float)entity.getYaw(), (float)0.0f, (float)-1.0f, (float)0.0f);
        float f = 0.0625f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        float size = 1.0f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.isOnWall() ? -0.24f : -0.12f), (float)0.5f);
        this.renderForEnum(entity.getSkullType(), entity.isOnWall());
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private void renderForEnum(EnumSkullType skull, boolean onWall) {
        switch (skull) {
            case HIPPOGRYPH: {
                GL11.glTranslatef((float)0.0f, (float)-0.0f, (float)-0.2f);
                GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
                this.hippogryphModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.hippogryphModel.Head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-5.0), 0.0f, 0.0f);
                this.hippogryphModel.Head.func_78785_a(0.0625f);
                break;
            }
            case CYCLOPS: {
                GL11.glTranslatef((float)0.0f, (float)1.8f, (float)-0.5f);
                GL11.glScalef((float)2.25f, (float)2.25f, (float)2.25f);
                this.cyclopsModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.cyclopsModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cyclopsModel.Head.func_78785_a(0.0625f);
                break;
            }
            case COCKATRICE: {
                if (onWall) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.35f);
                }
                this.cockatriceModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.cockatriceModel.head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cockatriceModel.head.func_78785_a(0.0625f);
                break;
            }
            case STYMPHALIAN: {
                if (!onWall) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.35f);
                }
                this.stymphalianBirdModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.stymphalianBirdModel.HeadBase, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.stymphalianBirdModel.HeadBase.func_78785_a(0.0625f);
                break;
            }
            case TROLL: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-0.35f);
                if (onWall) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.35f);
                }
                this.trollModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.trollModel.head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-20.0), 0.0f, 0.0f);
                this.trollModel.head.func_78785_a(0.0625f);
                break;
            }
            case AMPHITHERE: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.7f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                this.amphithereModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.amphithereModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.amphithereModel.Head.func_78785_a(0.0625f);
                break;
            }
            case SEASERPENT: {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.8f);
                GL11.glScalef((float)2.5f, (float)2.5f, (float)2.5f);
                this.seaSerpentModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.seaSerpentModel.getCube("Head"), onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.seaSerpentModel.getCube("Head").func_78785_a(0.0625f);
                break;
            }
            case HYDRA: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)-0.1f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                this.hydraModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.hydraModel.Head1, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.hydraModel.Head1.func_78785_a(0.0625f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityMobSkull entity) {
        String s = "iceandfire:textures/models/skulls/skull_" + entity.getSkullType().name().toLowerCase() + ".png";
        ResourceLocation resourcelocation = SKULL_TEXTURE_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            SKULL_TEXTURE_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

