/*
 * Decompiled with CFR 0.152.
 */
package illager.guardillagers.utils;

import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;

public class IllagerShieldUtils {
    private static ItemStack getIllagerBanner() {
        ItemStack banner = new ItemStack(Items.field_179564_cE);
        IllagerShieldUtils.addPattern(banner, BannerPattern.BASE, EnumDyeColor.WHITE);
        IllagerShieldUtils.addPattern(banner, BannerPattern.RHOMBUS_MIDDLE, EnumDyeColor.CYAN);
        IllagerShieldUtils.addPattern(banner, BannerPattern.STRIPE_BOTTOM, EnumDyeColor.SILVER);
        IllagerShieldUtils.addPattern(banner, BannerPattern.STRIPE_CENTER, EnumDyeColor.GRAY);
        IllagerShieldUtils.addPattern(banner, BannerPattern.STRIPE_MIDDLE, EnumDyeColor.BLACK);
        IllagerShieldUtils.addPattern(banner, BannerPattern.HALF_HORIZONTAL, EnumDyeColor.SILVER);
        IllagerShieldUtils.addPattern(banner, BannerPattern.CIRCLE_MIDDLE, EnumDyeColor.SILVER);
        return banner;
    }

    private static ItemStack addPattern(ItemStack banner, BannerPattern pattern, EnumDyeColor color) {
        NBTTagList patterns;
        NBTTagCompound tag;
        NBTTagCompound nbt = banner.func_77978_p();
        if (nbt == null) {
            banner.func_77982_d(new NBTTagCompound());
            nbt = banner.func_77978_p();
        }
        if (nbt.func_74764_b("BlockEntityTag")) {
            tag = nbt.func_74775_l("BlockEntityTag");
        } else {
            tag = new NBTTagCompound();
            nbt.func_74782_a("BlockEntityTag", (NBTBase)tag);
        }
        if (tag.func_74764_b("Patterns")) {
            patterns = tag.func_150295_c("Patterns", 10);
        } else {
            patterns = new NBTTagList();
            tag.func_74782_a("Patterns", (NBTBase)patterns);
        }
        NBTTagCompound toAdd = new NBTTagCompound();
        toAdd.func_74768_a("Color", color.func_176767_b());
        toAdd.func_74778_a("Pattern", pattern.func_190993_b());
        patterns.func_74742_a((NBTBase)toAdd);
        return banner;
    }

    public static ItemStack getIllagerShield() {
        ItemStack banner = IllagerShieldUtils.getIllagerBanner();
        ItemStack shield = new ItemStack(Items.field_185159_cQ, 1, 0);
        IllagerShieldUtils.applyBanner(banner, shield);
        return shield;
    }

    private static void applyBanner(ItemStack banner, ItemStack shield) {
        NBTTagCompound bannerNBT = banner.func_179543_a("BlockEntityTag");
        NBTTagCompound shieldNBT = bannerNBT == null ? new NBTTagCompound() : bannerNBT.func_74737_b();
        shieldNBT.func_74768_a("Base", banner.func_77960_j() & 0xF);
        shield.func_77983_a("BlockEntityTag", (NBTBase)shieldNBT);
    }
}

