/*
 * Decompiled with CFR 0.152.
 */
package illager.guardillagers.event;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import illager.guardillagers.entity.EntityGuardIllager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.WoodlandMansionPieces;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="guardillagers")
public class GuardSpawnHandler {
    private static final Logger LOGGER = LogManager.getLogger(GuardSpawnHandler.class);
    private static final ImmutableMultimap<String, SpawnEntry> SPAWN_ENTRIES = ImmutableMultimap.of((Object)"entrance", (Object)new SpawnEntry(EntityGuardIllager::new, 2, 3), (Object)"1x2_c_stairs", (Object)new SpawnEntry(EntityGuardIllager::new, 2, 2).withFloorPredicate(state -> state.func_177230_c() instanceof BlockStairs), (Object)"1x2_d_stairs", (Object)new SpawnEntry(EntityGuardIllager::new, 2, 2).withFloorPredicate(state -> state.func_177230_c() instanceof BlockStairs));
    private static final float SPAWN_SEARCH_ATTEMPT_FACTOR = 0.1f;
    private static final Field MANSION_FIELD = ReflectionHelper.findField(ChunkGeneratorOverworld.class, (String[])new String[]{"woodlandMansionGenerator", "field_191060_C"});
    private static final Field STRUCT_MAP_FIELD = ReflectionHelper.findField(MapGenStructure.class, (String[])new String[]{"structureMap", "field_75053_d"});
    private static final Field TEMPLATE_NAME_FIELD = ReflectionHelper.findField(WoodlandMansionPieces.MansionTemplate.class, (String[])new String[]{"templateName", "field_191082_d"});

    @Nullable
    private static Long2ObjectMap<StructureStart> getStructureMap(MapGenStructure generator) {
        try {
            return (Long2ObjectMap)STRUCT_MAP_FIELD.get(generator);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to get structure map on {}", (Object)generator, (Object)e);
            return null;
        }
    }

    @Nullable
    private static MapGenStructure getMansionGenerator(WorldServer world) {
        ChunkProviderServer chunkProvider = world.func_72863_F();
        if (chunkProvider.field_186029_c instanceof ChunkGeneratorOverworld) {
            try {
                return (MapGenStructure)MANSION_FIELD.get(chunkProvider.field_186029_c);
            }
            catch (ReflectiveOperationException e) {
                LOGGER.error("Failed to get mansion generator on {}", (Object)chunkProvider.field_186029_c, (Object)e);
            }
        }
        return null;
    }

    @Nullable
    private static String getTemplateName(StructureComponent component) {
        if (component instanceof WoodlandMansionPieces.MansionTemplate) {
            try {
                return (String)TEMPLATE_NAME_FIELD.get(component);
            }
            catch (ReflectiveOperationException e) {
                LOGGER.error("Failed to get template name for {}", (Object)component, (Object)e);
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void onPostPopulate(PopulateChunkEvent.Post event) {
        if (!(event.getWorld() instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.getWorld();
        MapGenStructure mansionGenerator = GuardSpawnHandler.getMansionGenerator(world);
        if (mansionGenerator == null) {
            return;
        }
        Long2ObjectMap<StructureStart> structureMap = GuardSpawnHandler.getStructureMap(mansionGenerator);
        if (structureMap == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(event.getChunkX(), event.getChunkZ());
        StructureBoundingBox chunkBounds = new StructureBoundingBox(chunkPos.func_180334_c(), chunkPos.func_180333_d(), chunkPos.func_180332_e(), chunkPos.func_180330_f());
        Stream<StructureStart> intersectingStructures = structureMap.values().stream().filter(structure -> structure.func_75071_a().func_78884_a(chunkBounds));
        intersectingStructures.forEach(structure -> {
            Stream<StructureComponent> intersectingComponents = structure.func_186161_c().stream().filter(component -> component.func_74874_b().func_78884_a(chunkBounds)).filter(component -> GuardSpawnHandler.isComponentFullyGenerated((World)world, component));
            StructureBoundingBox structureBounds = structure.func_75071_a();
            intersectingComponents.forEach(component -> GuardSpawnHandler.populateComponent((World)world, structureBounds, component));
        });
    }

    private static boolean isComponentFullyGenerated(World world, StructureComponent component) {
        StructureBoundingBox boundingBox = component.func_74874_b();
        ChunkPos minChunkPos = GuardSpawnHandler.chunkFromBlock(boundingBox.field_78897_a, boundingBox.field_78896_c);
        ChunkPos maxChunkPos = GuardSpawnHandler.chunkFromBlock(boundingBox.field_78893_d, boundingBox.field_78892_f);
        for (int chunkZ = minChunkPos.field_77275_b; chunkZ <= maxChunkPos.field_77275_b; ++chunkZ) {
            for (int chunkX = minChunkPos.field_77276_a; chunkX <= maxChunkPos.field_77276_a; ++chunkX) {
                if (GuardSpawnHandler.isChunkPopulated(world, chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isChunkPopulated(World world, int chunkX, int chunkZ) {
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        return chunk.func_177419_t();
    }

    private static void populateComponent(World world, StructureBoundingBox structureBounds, StructureComponent component) {
        String templateName = GuardSpawnHandler.getTemplateName(component);
        if (templateName == null) {
            return;
        }
        long seed = world.func_72905_C() ^ GuardSpawnHandler.hash(structureBounds);
        Random random = new Random(seed);
        ImmutableCollection spawnEntries = SPAWN_ENTRIES.get((Object)templateName);
        for (SpawnEntry spawnEntry : spawnEntries) {
            GuardSpawnHandler.spawnGroup(world, random, structureBounds, component, spawnEntry);
        }
    }

    private static void spawnGroup(World world, Random random, StructureBoundingBox structureBounds, StructureComponent component, SpawnEntry spawnEntry) {
        BlockPos structureCenter = new BlockPos((structureBounds.field_78893_d + structureBounds.field_78897_a) / 2, (structureBounds.field_78894_e + structureBounds.field_78895_b) / 2, (structureBounds.field_78892_f + structureBounds.field_78896_c) / 2);
        int structureRadius = Math.max(Math.max(structureBounds.func_78883_b(), structureBounds.func_78882_c()), structureBounds.func_78880_d()) / 2;
        int groupSize = random.nextInt(spawnEntry.groupMax - spawnEntry.groupMin + 1) + spawnEntry.groupMin;
        for (int i = 0; i < groupSize; ++i) {
            Entity entity = spawnEntry.create(world);
            BlockPos spawnLocation = GuardSpawnHandler.tryFindSpawnLocationIn(world, random, spawnEntry, entity, component.func_74874_b());
            if (spawnLocation == null) {
                return;
            }
            float yaw = random.nextFloat() * 360.0f;
            entity.func_70080_a((double)spawnLocation.func_177958_n() + 0.5, (double)spawnLocation.func_177956_o(), (double)spawnLocation.func_177952_p() + 0.5, yaw, 0.0f);
            world.func_72838_d(entity);
            if (!(entity instanceof EntityCreature)) continue;
            ((EntityCreature)entity).func_175449_a(structureCenter, structureRadius);
        }
    }

    @Nullable
    private static BlockPos tryFindSpawnLocationIn(World world, Random random, SpawnEntry spawnEntry, Entity entity, StructureBoundingBox bounds) {
        int floorArea = bounds.func_78883_b() * bounds.func_78880_d();
        int attempts = MathHelper.func_76123_f((float)((float)floorArea * 0.1f));
        for (int i = 0; i < attempts; ++i) {
            BlockPos spawnPos;
            AxisAlignedBB boundsInPlace;
            IBlockState state;
            BlockPos floor;
            BlockPos pos = GuardSpawnHandler.randomPositionIn(bounds, random);
            if (!world.func_175623_d(pos) || (floor = GuardSpawnHandler.findFloor(world, pos, bounds.field_78895_b)) == null || !spawnEntry.canSpawnOn(state = world.func_180495_p(floor)) || world.func_184143_b(boundsInPlace = GuardSpawnHandler.getEntityBoundsAt(entity, (double)(spawnPos = floor.func_177984_a()).func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5))) continue;
            return spawnPos;
        }
        return null;
    }

    private static AxisAlignedBB getEntityBoundsAt(Entity entity, double x, double y, double z) {
        float width = entity.field_70130_N / 2.0f;
        float height = entity.field_70131_O;
        return new AxisAlignedBB(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width);
    }

    @Nullable
    private static BlockPos findFloor(World world, BlockPos pos, int minY) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        while (mutablePos.func_177956_o() > minY) {
            mutablePos.func_189536_c(EnumFacing.DOWN);
            if (world.func_180495_p((BlockPos)mutablePos).func_185890_d((IBlockAccess)world, (BlockPos)mutablePos) == null) continue;
            return mutablePos.func_185334_h();
        }
        return null;
    }

    private static BlockPos randomPositionIn(StructureBoundingBox bounds, Random random) {
        return new BlockPos(bounds.field_78897_a + random.nextInt(bounds.func_78883_b()), bounds.field_78895_b + random.nextInt(bounds.func_78882_c()), bounds.field_78896_c + random.nextInt(bounds.func_78880_d()));
    }

    private static ChunkPos chunkFromBlock(int x, int z) {
        return new ChunkPos(x >> 4, z >> 4);
    }

    private static long hash(StructureBoundingBox bounds) {
        long min = (bounds.field_78895_b + bounds.field_78896_c * 31) * 31 + bounds.field_78897_a;
        long max = (bounds.field_78894_e + bounds.field_78892_f * 31) * 31 + bounds.field_78893_d;
        return min * 31L + max;
    }

    private static class SpawnEntry {
        private final Function<World, Entity> constructor;
        private final int groupMin;
        private final int groupMax;
        private Predicate<IBlockState> floorPredicate = state -> true;

        private SpawnEntry(Function<World, Entity> constructor, int groupMin, int groupMax) {
            this.constructor = constructor;
            this.groupMin = groupMin;
            this.groupMax = groupMax;
        }

        public SpawnEntry withFloorPredicate(Predicate<IBlockState> predicate) {
            this.floorPredicate = predicate;
            return this;
        }

        public boolean canSpawnOn(IBlockState state) {
            return this.floorPredicate.test(state);
        }

        public Entity create(World world) {
            return this.constructor.apply(world);
        }
    }
}

