/*
 * Decompiled with CFR 0.152.
 */
package illager.guardillagers.entity;

import com.google.common.base.Function;
import illager.guardillagers.GuardIllagers;
import illager.guardillagers.init.IllagerItems;
import illager.guardillagers.init.IllagerSoundsRegister;
import illager.guardillagers.utils.IllagerShieldUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGuardIllager
extends AbstractIllager {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> IS_DRINKING = EntityDataManager.func_187226_a(EntityGuardIllager.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_STRONG = EntityDataManager.func_187226_a(EntityGuardIllager.class, (DataSerializer)DataSerializers.field_187198_h);
    private int potionUseTimer;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;

    public EntityGuardIllager(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        this.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.4f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{AbstractIllager.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIAttackPlayer());
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.348f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(22.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(7.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_DRINKING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_STRONG, (Object)false);
    }

    public void setDrinkingPotion(boolean drinkingPotion) {
        this.func_184212_Q().func_187227_b(IS_DRINKING, (Object)drinkingPotion);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DRINKING);
    }

    public boolean isStrong() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STRONG);
    }

    public void setStrong(boolean strong) {
        this.field_70180_af.func_187227_b(IS_STRONG, (Object)strong);
        if (strong) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Strong", this.isStrong());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setStrong(compound.func_74767_n("Strong"));
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isDrinkingPotion()) {
                if (this.potionUseTimer-- <= 0) {
                    List list;
                    this.setDrinkingPotion(false);
                    ItemStack itemstack = this.func_184592_cb();
                    if (this.isStrong()) {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, IllagerShieldUtils.getIllagerShield());
                    } else {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    }
                    if (itemstack.func_77973_b() == Items.field_151068_bn && (list = PotionUtils.func_185189_a((ItemStack)itemstack)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.func_70690_d(new PotionEffect(potioneffect));
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else {
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.004f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potiontype = PotionTypes.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.008f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                    potiontype = PotionTypes.field_185243_o;
                }
                if (potiontype != null) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                    this.potionUseTimer = this.func_184592_cb().func_77988_m();
                    this.setDrinkingPotion(true);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iattributeinstance.func_111124_b(MODIFIER);
                    iattributeinstance.func_111121_a(MODIFIER);
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateCape();
    }

    private void updateCape() {
        double elasticity = 0.25;
        double gravity = -0.1;
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        this.capeY += gravity;
        this.capeX += (this.field_70165_t - this.capeX) * elasticity;
        this.capeY += (this.field_70163_u - this.capeY) * elasticity;
        this.capeZ += (this.field_70161_v - this.capeZ) * elasticity;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null && livingBase instanceof EntityPlayer && !((EntityPlayer)livingBase).func_184812_l_() && this.func_70089_S()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GuardIllagers.LOOT_TABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.func_193078_a(1);
    }

    public void setAggressive(boolean p_190636_1_) {
        this.func_193079_a(1, p_190636_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public AbstractIllager.IllagerArmPose func_193077_p() {
        return this.isAggressive() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public void setHomePos() {
        this.func_175449_a(new BlockPos((Entity)this), 26);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.setStrong(true);
        }
        return super.func_180482_a(difficulty, entityLivingData);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        if (this.isStrong()) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, IllagerShieldUtils.getIllagerShield());
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.setAggressive(this.func_70638_az() != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        if (this.field_70146_Z.nextInt(5) != 0) return false;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) return false;
        if (!(this.field_70163_u > 60.0)) return false;
        if (!(this.field_70163_u < 90.0)) return false;
        if (this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) return false;
        if (this.field_70170_p.func_175699_k(blockpos) <= 6) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        if (this.isAggressive()) {
            return IllagerSoundsRegister.GUARDILLAGER_ANGRY;
        }
        return IllagerSoundsRegister.GUARDILLAGER_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return IllagerSoundsRegister.GUARDILLAGER_DIE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return IllagerSoundsRegister.GUARDILLAGER_HURT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        SoundType soundtype = blockIn.getSoundType(this.field_70170_p.func_180495_p(pos), this.field_70170_p, pos, (Entity)this);
        SoundEvent soundEvent = IllagerSoundsRegister.GUARDILLAGER_STEP;
        if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
            soundtype = Blocks.field_150431_aC.func_185467_w();
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        } else if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            this.func_184185_a(soundEvent, 0.2f, soundtype.func_185847_b());
        }
    }

    public class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private EntityPlayer player;

        public AIAttackPlayer() {
            super((EntityCreature)EntityGuardIllager.this, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            if (super.func_75250_a()) {
                this.field_75309_a = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

                    @Nullable
                    public Double apply(@Nullable EntityPlayer p_apply_1_) {
                        ItemStack itemstack = p_apply_1_.func_184582_a(EntityEquipmentSlot.HEAD);
                        if (itemstack.func_77973_b() == IllagerItems.GUARD_HELMET) {
                            return 0.5;
                        }
                        return 1.0;
                    }
                }, this.field_82643_g);
                return this.field_75309_a != null;
            }
            return false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }
    }
}

