/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world;

import com.google.common.base.Predicate;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.world.gen.WorldGenAshPath;
import fossilsarcheology.server.world.gen.WorldGenVolcanoCone;
import fossilsarcheology.server.world.gen.WorldGenVolcanoFossils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FAVolcanoBiome
extends Biome {
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();

    public FAVolcanoBiome() {
        super(new Biome.BiomeProperties("Volcano").func_185398_c(1.5f).func_185400_d(0.5f).func_185410_a(2.0f).func_185395_b(0.0f).func_185402_a(0x300000));
        this.field_76752_A = FABlockRegistry.VOLCANIC_ROCK.func_176223_P();
        this.field_76753_B = FABlockRegistry.VOLCANIC_ROCK.func_176223_P();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76804_C = 4;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, rand, pos));
        DiamondGen gen = new DiamondGen();
        if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)gen, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            gen.func_180709_b(worldIn, rand, pos);
        }
        if (rand.nextInt(50) == 0) {
            new WorldGenVolcanoCone().func_180709_b(worldIn, rand, worldIn.func_175645_m(pos).func_177981_b(3));
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && rand.nextInt(10) == 0) {
            new WorldGenVolcanoFossils().func_180709_b(worldIn, rand, worldIn.func_175645_m(pos).func_177979_c(5 + rand.nextInt(12)));
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL)) {
            for (int l = 0; l < 2; ++l) {
                int i1 = rand.nextInt(16) + 8;
                int j1 = rand.nextInt(16) + 8;
                new WorldGenAshPath(4 + rand.nextInt(6), false).func_180709_b(worldIn, rand, worldIn.func_175645_m(pos.func_177982_a(i1, worldIn.func_189649_b(pos.func_177958_n(), pos.func_177952_p()), j1)));
            }
        }
        if (rand.nextInt(3) == 0) {
            int i1 = rand.nextInt(16) + 8;
            int j1 = rand.nextInt(16) + 8;
            new WorldGenAshPath(2 + rand.nextInt(3), true).func_180709_b(worldIn, rand, worldIn.func_175645_m(pos.func_177982_a(i1, worldIn.func_189649_b(pos.func_177958_n(), pos.func_177952_p()), j1)));
        }
        for (int i = 0; i < 5; ++i) {
            int i2 = rand.nextInt(16) + 8;
            int k3 = rand.nextInt(16) + 8;
            if (rand.nextInt(8) != 0) continue;
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(worldIn, rand, pos.func_177982_a(i2, worldIn.func_189649_b(pos.func_177958_n(), pos.func_177952_p()) + 3, k3));
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateBiomeTerrainVolcano(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void generateBiomeTerrainVolcano(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int i1 = x & 0xF;
        int l = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = LAVA;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    chunkPrimerIn.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != FABlockRegistry.VOLCANIC_ROCK || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 0x110000;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 0x808080;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 0x808080;
    }

    private static class DiamondGen
    extends WorldGenerator {
        private DiamondGen() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + offset, rand.nextInt(38) + 4, rand.nextInt(16) + offset);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150482_ag.func_176223_P(), 18);
            }
            return true;
        }
    }
}

