/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.structure;

import fossilsarcheology.server.block.FigurineBlock;
import fossilsarcheology.server.block.VaseBlock;
import fossilsarcheology.server.structure.FABlockProcessorLoot;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FABlockProcessorVillage
extends FABlockProcessorLoot {
    private Biome biome;
    private EnumFacing facing;

    public FABlockProcessorVillage(BlockPos pos, PlacementSettings settings, ResourceLocation loot, Biome biome, EnumFacing facing) {
        super(pos, settings, loot);
        this.biome = biome;
        this.facing = facing;
    }

    @Override
    @Nullable
    public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
        if (blockInfoIn.field_186243_b.func_177230_c() instanceof FigurineBlock) {
            NBTTagCompound tag = blockInfoIn.field_186244_c == null ? new NBTTagCompound() : blockInfoIn.field_186244_c;
            tag.func_74768_a("FigurineType", this.random.nextInt(15));
            tag.func_74768_a("Rot", Math.max(this.facing.func_176736_b(), 0));
            return new Template.BlockInfo(pos, blockInfoIn.field_186243_b, tag);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() instanceof VaseBlock) {
            NBTTagCompound tag = blockInfoIn.field_186244_c == null ? new NBTTagCompound() : blockInfoIn.field_186244_c;
            tag.func_74768_a("Rot", Math.max(this.facing.func_176736_b(), 0));
            return new Template.BlockInfo(pos, blockInfoIn.field_186243_b, tag);
        }
        if (blockInfoIn.field_186243_b.func_177230_c() instanceof BlockChest) {
            return super.func_189943_a(worldIn, pos, blockInfoIn);
        }
        return new Template.BlockInfo(pos, this.getBiomeSpecificBlockState(blockInfoIn.field_186243_b, this.biome), null);
    }

    protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn, Biome biome) {
        BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(biome, blockstateIn);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        int structureType = 0;
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            structureType = 1;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            structureType = 2;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            structureType = 3;
        }
        if (event.getResult() == Event.Result.DENY) {
            return event.getReplacement();
        }
        if (blockstateIn.func_177230_c() instanceof BlockDoor && blockstateIn.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            EnumFacing facing = (EnumFacing)blockstateIn.func_177229_b((IProperty)BlockDoor.field_176520_a);
            return this.biomeDoor(structureType).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing);
        }
        if (blockstateIn.func_177230_c() instanceof BlockDoor && blockstateIn.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            EnumFacing facing = (EnumFacing)blockstateIn.func_177229_b((IProperty)BlockDoor.field_176520_a);
            return this.biomeDoor(structureType).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
        }
        if (structureType == 1) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150322_A.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.DEFAULT.func_176675_a());
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150346_d) {
                return Blocks.field_150354_m.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150349_c) {
                return Blocks.field_150322_A.func_176223_P();
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a());
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                return Blocks.field_150322_A.func_176223_P();
            }
        } else if (structureType == 3) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                return Blocks.field_180408_aP.func_176223_P();
            }
        } else if (structureType == 2) {
            if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                return Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
            }
            if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            }
            if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                return Blocks.field_180405_aT.func_176223_P();
            }
        }
        if (blockstateIn.func_177230_c() == Blocks.field_150349_c && structureType != 1) {
            return Blocks.field_185774_da.func_176223_P();
        }
        return blockstateIn;
    }

    protected IBlockState biomeDoor(int structureType) {
        switch (structureType) {
            case 2: {
                return Blocks.field_180410_as.func_176223_P();
            }
            case 3: {
                return Blocks.field_180414_ap.func_176223_P();
            }
        }
        return Blocks.field_180413_ao.func_176223_P();
    }
}

