/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.item.DinosaurBoneItem;
import fossilsarcheology.server.item.ItemDinoMeat;
import fossilsarcheology.server.item.variant.DinosaurBoneType;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class CustomizeToDinosaur
extends LootFunction {
    public CustomizeToDinosaur(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public static int getMetaForDino(PrehistoricEntityType type) {
        if (DinosaurBoneType.get(type) != null) {
            return DinosaurBoneType.get(type).ordinal();
        }
        return 0;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (!stack.func_190926_b() && context.func_186493_a() instanceof EntityPrehistoric) {
            EntityPrehistoric dino = (EntityPrehistoric)context.func_186493_a();
            PrehistoricEntityType type = dino.type;
            if (stack.func_77973_b() instanceof ItemDinoMeat) {
                stack.func_190920_e(Math.min(dino.getAgeInDays(), dino.getAdultAge()));
                return new ItemStack(dino.func_70027_ad() ? type.cookedFoodItem : type.foodItem, stack.func_190916_E(), stack.func_77960_j());
            }
            if (stack.func_77973_b() instanceof DinosaurBoneItem) {
                return new ItemStack(stack.func_77973_b(), stack.func_190916_E(), CustomizeToDinosaur.getMetaForDino(type));
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<CustomizeToDinosaur> {
        public Serializer() {
            super(new ResourceLocation("fossil:customize_to_dinosaur"), CustomizeToDinosaur.class);
        }

        public void serialize(JsonObject object, CustomizeToDinosaur functionClazz, JsonSerializationContext serializationContext) {
        }

        public CustomizeToDinosaur deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new CustomizeToDinosaur(conditionsIn);
        }
    }
}

