/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.ai;

import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.util.FoodMappings;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;

public class DinoAIEatItems
extends EntityAIBase {
    private final EntityPrehistoric prehistoric;
    private final ItemsSorter targetSorter;
    private EntityItem targetItem;

    public DinoAIEatItems(EntityPrehistoric prehistoric) {
        this.prehistoric = prehistoric;
        this.targetSorter = new ItemsSorter((Entity)prehistoric);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.prehistoric.getHunger() >= this.prehistoric.getMaxHunger()) {
            return false;
        }
        if (this.prehistoric.isMovementBlockedSoft()) {
            return false;
        }
        this.targetItem = this.getNearestItem(16);
        return this.targetItem != null;
    }

    public boolean func_75253_b() {
        if (this.targetItem == null || !this.targetItem.func_70089_S()) {
            return false;
        }
        if (this.prehistoric.getHunger() >= this.prehistoric.getMaxHunger()) {
            return false;
        }
        return !this.prehistoric.isMovementBlockedSoft();
    }

    public void func_75246_d() {
        double distance = Math.sqrt(Math.pow(this.prehistoric.field_70165_t - this.targetItem.field_70165_t, 2.0) + Math.pow(this.prehistoric.field_70161_v - this.targetItem.field_70161_v, 2.0));
        this.prehistoric.func_70661_as().func_75492_a(this.targetItem.field_70165_t, this.targetItem.field_70163_u, this.targetItem.field_70161_v, 1.0);
        if (distance < Math.max(this.prehistoric.func_174813_aQ().func_72320_b(), 2.5) && this.targetItem != null) {
            this.prehistoric.eatItem(this.targetItem.func_92059_d());
            this.targetItem.func_92059_d().func_190918_g(1);
        }
        if (this.prehistoric.func_70661_as().func_75500_f()) {
            this.func_75251_c();
        }
    }

    private EntityItem getNearestItem(int range) {
        List nearbyItems = this.prehistoric.field_70170_p.func_72872_a(EntityItem.class, this.prehistoric.func_174813_aQ().func_72314_b((double)range, (double)range, (double)range));
        nearbyItems.sort(this.targetSorter);
        for (EntityItem currentItem : nearbyItems) {
            int foodValue;
            if (currentItem.func_92059_d().func_190926_b() || (foodValue = FoodMappings.INSTANCE.getItemFoodAmount(currentItem.func_92059_d(), this.prehistoric.type.diet)) <= 0 || this.prehistoric.isPreyBlocked((Entity)currentItem)) continue;
            return currentItem;
        }
        return null;
    }

    public class ItemsSorter
    implements Comparator<Entity> {
        private final Entity entity;

        public ItemsSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double distance1 = this.entity.func_70068_e(entity1);
            double distance2 = this.entity.func_70068_e(entity2);
            return Double.compare(distance1, distance2);
        }
    }
}

