/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity;

import fossilsarcheology.Revival;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.OrderType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.utility.FossilsPlayerProperties;
import fossilsarcheology.server.item.FAItemRegistry;
import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityDinosaurEgg
extends EntityLiving
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> HATCHING_INDEX = EntityDataManager.func_187226_a(EntityDinosaurEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    public static int lastBirthTick;
    public final int totalHatchTime = this.hatchTime;
    public PrehistoricEntityType selfType;
    public String parentOwner = "";
    private int hatchTime;
    private boolean hasMessagedPlayer = false;

    public EntityDinosaurEgg(World world, PrehistoricEntityType prehistoric) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.5f, 0.6f);
        this.selfType = prehistoric;
        lastBirthTick = 0;
    }

    public EntityDinosaurEgg(World world) {
        this(world, PrehistoricEntityType.TRICERATOPS);
    }

    public EntityDinosaurEgg(World world, PrehistoricEntityType prehistoric, EntityPrehistoric entity) {
        this(world, prehistoric);
        this.parentOwner = entity.func_145748_c_().toString();
    }

    public EntityDinosaurEgg(World world, double x, double y, double z, PrehistoricEntityType prehistoric) {
        this(world, prehistoric);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.hatchTime = Revival.RELEASE_TYPE.enableDebugging() ? 1000 : 3000;
        this.field_70180_af.func_187214_a(HATCHING_INDEX, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public String getTexture() {
        return "fossil:textures/model/egg/" + this.selfType.friendlyName + "_Egg.png";
    }

    private void setPedia() {
        Revival.PEDIA_OBJECT = this;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public int getBirthTick() {
        return (Integer)this.field_70180_af.func_187225_a(HATCHING_INDEX);
    }

    public void setBirthTick(int i) {
        this.field_70180_af.func_187227_b(HATCHING_INDEX, (Object)i);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickHatching();
    }

    public boolean isCold() {
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        float light = this.field_70170_p.func_175724_o(new BlockPos((Entity)this));
        float temperature = biome.func_180626_a(new BlockPos((Entity)this));
        if (temperature <= 0.15f) {
            return light < 0.75f;
        }
        return light < 0.5f;
    }

    private void tickHatching() {
        Entity entity;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 16.0);
        if (this.isCold() || this.field_70171_ac) {
            if (this.getBirthTick() > 0) {
                this.setBirthTick(this.getBirthTick() - 1);
            }
        } else {
            lastBirthTick = this.getBirthTick();
            this.setBirthTick(this.getBirthTick() + 1);
        }
        if (this.getBirthTick() >= this.totalHatchTime && (entity = this.selfType.invokeClass(this.field_70170_p)) != null) {
            if (entity instanceof EntityPrehistoric) {
                EntityPrehistoric prehistoricEntity = (EntityPrehistoric)entity;
                if (prehistoricEntity.type.isTameable() && player != null && prehistoricEntity.aiTameType() == PrehistoricEntityTypeAI.Taming.IMPRINTING) {
                    prehistoricEntity.func_70903_f(true);
                    prehistoricEntity.func_184754_b(player.func_110124_au());
                    FossilsPlayerProperties properties = (FossilsPlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, FossilsPlayerProperties.class);
                    if (properties != null && !properties.hasHatchedDinosaur) {
                        properties.hasHatchedDinosaur = true;
                        Revival.PROXY.playSound(FASoundRegistry.MUSIC_FIRST_DINOSAUR);
                    }
                    prehistoricEntity.setOwnerDisplayName(player.func_70005_c_());
                    prehistoricEntity.currentOrder = OrderType.WANDER;
                    prehistoricEntity.func_70606_j((float)prehistoricEntity.baseHealth);
                }
                prehistoricEntity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)prehistoricEntity)), null);
                prehistoricEntity.setAgeInDays(0);
                prehistoricEntity.grow(0);
                prehistoricEntity.updateAbilities();
                prehistoricEntity.func_94061_f(false);
            }
            entity.func_70012_b(Math.floor(this.field_70165_t), Math.floor(this.field_70163_u) + 1.0, Math.floor(this.field_70161_v), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.hasMessagedPlayer) {
                for (int i = 0; i < 4; ++i) {
                    double x = this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                    double y = this.func_174813_aQ().field_72338_b + 0.1;
                    double z = this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                    double motionX = (double)this.field_70146_Z.nextFloat() - 0.5;
                    double motionZ = (double)this.field_70146_Z.nextFloat() - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, motionX, 0.5, motionZ, new int[]{Item.func_150891_b((Item)this.selfType.eggItem)});
                }
                if (this.field_70170_p.field_72995_K && player != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("dinoegg.hatched", new Object[0]), false);
                }
                this.hasMessagedPlayer = true;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d(entity);
            }
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("BirthTick", this.getBirthTick());
        compound.func_74768_a("DinoType", this.selfType.ordinal());
        compound.func_74778_a("ParentOwner", this.parentOwner);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setBirthTick(compound.func_74762_e("BirthTick"));
        this.selfType = PrehistoricEntityType.values()[compound.func_74762_e("DinoType")];
        this.parentOwner = compound.func_74779_i("ParentOwner");
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (damage > 0.0f && !this.field_70128_L && !this.field_70170_p.field_72995_K) {
            Item item = this.selfType.eggItem;
            ItemStack stack = new ItemStack(item);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack));
            this.field_70170_p.func_184133_a(null, new BlockPos((Entity)this), SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.func_70106_y();
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack == null) {
            Item item = this.selfType.eggItem;
            ItemStack eggstack = new ItemStack(item);
            if (!player.field_71075_bZ.field_75098_d && player.field_71071_by.func_70441_a(eggstack)) {
                this.field_70170_p.func_184133_a(null, new BlockPos((Entity)this), SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            this.func_70106_y();
            return true;
        }
        if (FMLCommonHandler.instance().getSide().isClient() && itemstack.func_77973_b() == FAItemRegistry.DINOPEDIA) {
            this.setPedia();
            player.openGui((Object)Revival.INSTANCE, 6, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.selfType.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.selfType = PrehistoricEntityType.values()[additionalData.readInt()];
    }
}

