/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public class WeakHelper {
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static <T> Iterable<CollectionHelper.ObjectIntEntry<T>> wrapObjectFloat(Iterable<CollectionHelper.ObjectIntEntry<WeakReference<T>>> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<CollectionHelper.ObjectIntEntry<T>>(){
                int nextInt;
                Object nextObject;
                CollectionHelper.ObjectIntEntry entry = new CollectionHelper.ObjectIntEntry<T>(){

                    @Override
                    public T getObject() {
                        return nextObject;
                    }

                    @Override
                    public int getInt() {
                        return nextInt;
                    }
                };

                @Override
                public boolean hasNext() {
                    while (iterator.hasNext()) {
                        CollectionHelper.ObjectIntEntry next = (CollectionHelper.ObjectIntEntry)iterator.next();
                        this.nextObject = ((WeakReference)next.getObject()).get();
                        if (this.nextObject == null) continue;
                        this.nextInt = next.getInt();
                        return true;
                    }
                    return false;
                }

                @Override
                public CollectionHelper.ObjectIntEntry<T> next() {
                    return this.entry;
                }
            };
        };
    }

    public static <T> Iterable<CollectionHelper.ObjectFloatEntry<T>> wrapObjectInt(Iterable<CollectionHelper.ObjectFloatEntry<WeakReference<T>>> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<CollectionHelper.ObjectFloatEntry<T>>(){
                float nextFloat;
                Object nextObject;
                CollectionHelper.ObjectFloatEntry entry = new CollectionHelper.ObjectFloatEntry<T>(){

                    @Override
                    public T getKey() {
                        return nextObject;
                    }

                    @Override
                    public float getValue() {
                        return nextFloat;
                    }
                };

                @Override
                public boolean hasNext() {
                    while (iterator.hasNext()) {
                        CollectionHelper.ObjectFloatEntry next = (CollectionHelper.ObjectFloatEntry)iterator.next();
                        this.nextObject = ((WeakReference)next.getKey()).get();
                        if (this.nextObject == null) continue;
                        this.nextFloat = next.getValue();
                        return true;
                    }
                    return false;
                }

                @Override
                public CollectionHelper.ObjectFloatEntry<T> next() {
                    return this.entry;
                }
            };
        };
    }

    public static <T> Iterable<T> wrapWeakIterator(final Iterable<WeakReference<T>> iterable, final boolean removeStaleEntries) {
        return () -> new Iterator<T>(){
            Iterator iterator;
            Object next;
            {
                this.iterator = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.iterator.hasNext()) {
                    this.next = ((WeakReference)this.iterator.next()).get();
                    if (this.next != null) {
                        return true;
                    }
                    if (!removeStaleEntries) continue;
                    this.iterator.remove();
                }
                return false;
            }

            @Override
            public T next() {
                return this.next;
            }
        };
    }
}

